/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic;

import ai.timefold.solver.benchmark.impl.statistic.ConstraintSummary;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.phase.event.PhaseLifecycleListener;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.solver.monitoring.SolverMetricUtil;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjLongConsumer;
import java.util.stream.Collectors;

public class StatisticRegistry<Solution_>
extends SimpleMeterRegistry
implements PhaseLifecycleListener<Solution_> {
    private static final String CONSTRAINT_PACKAGE_TAG = "constraint.package";
    private static final String CONSTRAINT_NAME_TAG = "constraint.name";
    List<Consumer<SolverScope<Solution_>>> solverMeterListenerList = new ArrayList<Consumer<SolverScope<Solution_>>>();
    List<BiConsumer<Long, AbstractStepScope<Solution_>>> stepMeterListenerList = new ArrayList<BiConsumer<Long, AbstractStepScope<Solution_>>>();
    List<BiConsumer<Long, AbstractStepScope<Solution_>>> bestSolutionMeterListenerList = new ArrayList<BiConsumer<Long, AbstractStepScope<Solution_>>>();
    AbstractStepScope<Solution_> bestSolutionStepScope = null;
    long bestSolutionChangedTimestamp = Long.MIN_VALUE;
    boolean lastStepImprovedSolution = false;
    ScoreDefinition<?> scoreDefinition;
    final Function<Number, Number> scoreLevelNumberConverter;

    public StatisticRegistry(ScoreDefinition<?> scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
        Number zeroScoreLevel0 = scoreDefinition.getZeroScore().toLevelNumbers()[0];
        if (zeroScoreLevel0 instanceof BigDecimal) {
            this.scoreLevelNumberConverter = number -> BigDecimal.valueOf(number.doubleValue());
        } else if (zeroScoreLevel0 instanceof BigInteger) {
            this.scoreLevelNumberConverter = number -> BigInteger.valueOf(number.longValue());
        } else if (zeroScoreLevel0 instanceof Double) {
            this.scoreLevelNumberConverter = Number::doubleValue;
        } else if (zeroScoreLevel0 instanceof Float) {
            this.scoreLevelNumberConverter = Number::floatValue;
        } else if (zeroScoreLevel0 instanceof Long) {
            this.scoreLevelNumberConverter = Number::longValue;
        } else if (zeroScoreLevel0 instanceof Integer) {
            this.scoreLevelNumberConverter = Number::intValue;
        } else if (zeroScoreLevel0 instanceof Short) {
            this.scoreLevelNumberConverter = Number::shortValue;
        } else if (zeroScoreLevel0 instanceof Byte) {
            this.scoreLevelNumberConverter = Number::byteValue;
        } else {
            throw new IllegalStateException("Cannot determine score level type for score definition (" + scoreDefinition.getClass().getName() + ").");
        }
    }

    public void addListener(SolverMetric metric, Consumer<Long> listener) {
        this.addListener(metric, (Long timestamp, AbstractStepScope<Solution_> stepScope) -> listener.accept((Long)timestamp));
    }

    public void addListener(SolverMetric metric, BiConsumer<Long, AbstractStepScope<Solution_>> listener) {
        if (metric.isMetricBestSolutionBased()) {
            this.bestSolutionMeterListenerList.add(listener);
        } else {
            this.stepMeterListenerList.add(listener);
        }
    }

    public void addListener(Consumer<SolverScope<Solution_>> listener) {
        this.solverMeterListenerList.add(listener);
    }

    public Set<Meter.Id> getMeterIds(SolverMetric metric, Tags runId) {
        return Search.in((MeterRegistry)this).name(name -> name.startsWith(metric.getMeterId())).tags((Iterable)runId).meters().stream().map(Meter::getId).collect(Collectors.toSet());
    }

    public void extractScoreFromMeters(SolverMetric metric, Tags runId, Consumer<InnerScore<?>> scoreConsumer) {
        InnerScore score = SolverMetricUtil.extractScore((SolverMetric)metric, this.scoreDefinition, id -> {
            Gauge scoreLevelGauge = this.find((String)id).tags((Iterable)runId).gauge();
            if (scoreLevelGauge != null && Double.isFinite(scoreLevelGauge.value())) {
                return this.scoreLevelNumberConverter.apply(scoreLevelGauge.value());
            }
            return null;
        });
        if (score != null) {
            scoreConsumer.accept(score);
        }
    }

    public void extractConstraintSummariesFromMeters(SolverMetric metric, Tags runId, Consumer<ConstraintSummary<?>> constraintMatchTotalConsumer) {
        this.getMeterIds(metric, runId).stream().map(meterId -> ConstraintRef.of((String)meterId.getTag(CONSTRAINT_PACKAGE_TAG), (String)meterId.getTag(CONSTRAINT_NAME_TAG))).distinct().forEach(constraintRef -> {
            Tags constraintMatchTotalRunId = runId.and(CONSTRAINT_PACKAGE_TAG, constraintRef.packageName()).and(CONSTRAINT_NAME_TAG, constraintRef.constraintName());
            this.extractScoreFromMeters(metric, constraintMatchTotalRunId, score -> {
                Double count = SolverMetricUtil.getGaugeValue((MeterRegistry)this, (String)SolverMetricUtil.getGaugeName((SolverMetric)metric, (String)"count"), (Tags)constraintMatchTotalRunId);
                if (count != null) {
                    constraintMatchTotalConsumer.accept(new ConstraintSummary<Score>((ConstraintRef)constraintRef, score.raw(), count.intValue()));
                }
            });
        });
    }

    public void extractMoveCountPerType(SolverScope<Solution_> solverScope, ObjLongConsumer<String> gaugeConsumer) {
        solverScope.getMoveCountTypes().forEach(type -> {
            Gauge gauge = this.find(SolverMetric.MOVE_COUNT_PER_TYPE.getMeterId() + "." + type).tags((Iterable)solverScope.getMonitoringTags()).gauge();
            if (gauge != null) {
                gaugeConsumer.accept((String)type, (long)gauge.value());
            }
        });
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        long timestamp = System.currentTimeMillis() - stepScope.getPhaseScope().getSolverScope().getStartingSystemTimeMillis();
        this.stepMeterListenerList.forEach(listener -> listener.accept(timestamp, stepScope));
        if (stepScope.getBestScoreImproved()) {
            this.bestSolutionStepScope = stepScope;
            this.bestSolutionChangedTimestamp = timestamp;
            this.lastStepImprovedSolution = true;
        }
    }

    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
    }

    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        if (this.lastStepImprovedSolution) {
            this.bestSolutionMeterListenerList.forEach(listener -> listener.accept(this.bestSolutionChangedTimestamp, this.bestSolutionStepScope));
            this.lastStepImprovedSolution = false;
        }
    }

    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
    }

    public void solvingStarted(SolverScope<Solution_> solverScope) {
    }

    public void solvingEnded(SolverScope<Solution_> solverScope) {
        if (this.lastStepImprovedSolution) {
            this.bestSolutionMeterListenerList.forEach(listener -> listener.accept(this.bestSolutionChangedTimestamp, this.bestSolutionStepScope));
            this.lastStepImprovedSolution = false;
        }
        this.solverMeterListenerList.forEach(listener -> listener.accept(solverScope));
    }
}

