/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.bestsolutionmutation;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationStatisticPoint;
import ai.timefold.solver.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationSubSingleStatistic;
import java.util.Collections;
import java.util.List;

public class BestSolutionMutationProblemStatistic
extends ProblemStatistic<LineChart<Long, Long>> {
    private BestSolutionMutationProblemStatistic() {
    }

    public BestSolutionMutationProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.BEST_SOLUTION_MUTATION);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new BestSolutionMutationSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    protected List<LineChart<Long, Long>> generateCharts(BenchmarkReport benchmarkReport) {
        LineChart.Builder<Long, Long> builder = new LineChart.Builder<Long, Long>();
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            String solverLabel = singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix();
            if (singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) {
                builder.markFavorite(solverLabel);
            }
            if (!singleBenchmarkResult.hasAllSuccess()) continue;
            SubSingleStatistic subSingleStatistic = singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
            List points = subSingleStatistic.getPointList();
            for (BestSolutionMutationStatisticPoint point : points) {
                long timeMillisSpent = point.getTimeMillisSpent();
                long mutationCount = point.getMutationCount();
                builder.add(solverLabel, timeMillisSpent, mutationCount);
                builder.add(solverLabel, timeMillisSpent + 1L, 0L);
            }
        }
        return Collections.singletonList(builder.build("bestSolutionMutationProblemStatisticChart", this.problemBenchmarkResult.getName() + " best solution mutation statistic", "Time spent", "Best solution mutation count", true, true, false));
    }
}

