/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.Chart;
import ai.timefold.solver.benchmark.impl.report.ReportHelper;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ChartProvider;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.bestscore.BestScoreProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.memoryuse.MemoryUseProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.movecountperstep.MoveCountPerStepProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.moveevaluationspeed.MoveEvaluationSpeedProblemStatisticTime;
import ai.timefold.solver.benchmark.impl.statistic.scorecalculationspeed.ScoreCalculationSpeedProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.stepscore.StepScoreProblemStatistic;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={BestScoreProblemStatistic.class, StepScoreProblemStatistic.class, ScoreCalculationSpeedProblemStatistic.class, MoveEvaluationSpeedProblemStatisticTime.class, BestSolutionMutationProblemStatistic.class, MoveCountPerStepProblemStatistic.class, MemoryUseProblemStatistic.class})
public abstract class ProblemStatistic<Chart_ extends Chart>
implements ChartProvider<Chart_> {
    @XmlTransient
    protected ProblemBenchmarkResult<Object> problemBenchmarkResult;
    @XmlTransient
    protected List<Chart_> chartList;
    protected ProblemStatisticType problemStatisticType;

    protected ProblemStatistic() {
    }

    protected ProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult, ProblemStatisticType problemStatisticType) {
        this.problemBenchmarkResult = problemBenchmarkResult;
        this.problemStatisticType = problemStatisticType;
    }

    public ProblemBenchmarkResult getProblemBenchmarkResult() {
        return this.problemBenchmarkResult;
    }

    public void setProblemBenchmarkResult(ProblemBenchmarkResult problemBenchmarkResult) {
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public ProblemStatisticType getProblemStatisticType() {
        return this.problemStatisticType;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.problemBenchmarkResult.getName() + "_" + this.problemStatisticType.name());
    }

    public List<SubSingleStatistic> getSubSingleStatisticList() {
        List<SingleBenchmarkResult> singleBenchmarkResultList = this.problemBenchmarkResult.getSingleBenchmarkResultList();
        ArrayList<SubSingleStatistic> subSingleStatisticList = new ArrayList<SubSingleStatistic>(singleBenchmarkResultList.size());
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            if (singleBenchmarkResult.getSubSingleBenchmarkResultList().isEmpty()) continue;
            subSingleStatisticList.add(singleBenchmarkResult.getSubSingleBenchmarkResultList().get(0).getEffectiveSubSingleStatisticMap().get(this.problemStatisticType));
        }
        return subSingleStatisticList;
    }

    public abstract SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult var1);

    @Override
    public final void createChartList(BenchmarkReport benchmarkReport) {
        this.chartList = this.generateCharts(benchmarkReport);
    }

    protected abstract List<Chart_> generateCharts(BenchmarkReport var1);

    @Override
    public final List<Chart_> getChartList() {
        return this.chartList;
    }

    public List<String> getWarningList() {
        return Collections.emptyList();
    }

    public String toString() {
        return String.valueOf(this.problemBenchmarkResult) + "_" + String.valueOf(this.problemStatisticType);
    }
}

