/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.stepscore;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.stepscore.StepScoreStatisticPoint;
import ai.timefold.solver.benchmark.impl.statistic.stepscore.StepScoreSubSingleStatistic;
import java.util.ArrayList;
import java.util.List;

public class StepScoreProblemStatistic
extends ProblemStatistic<LineChart<Long, Double>> {
    private StepScoreProblemStatistic() {
    }

    public StepScoreProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.STEP_SCORE);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new StepScoreSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    protected List<LineChart<Long, Double>> generateCharts(BenchmarkReport benchmarkReport) {
        ArrayList builderList = new ArrayList(15);
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            String solverLabel = singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix();
            if (!singleBenchmarkResult.hasAllSuccess()) continue;
            SubSingleStatistic subSingleStatistic = singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
            List points = subSingleStatistic.getPointList();
            for (StepScoreStatisticPoint point : points) {
                if (!point.isInitialized()) continue;
                long timeMillisSpent = point.getTimeMillisSpent();
                double[] levelValues = point.getScore().toLevelDoubles();
                for (int i = 0; i < levelValues.length && i < 15; ++i) {
                    if (i >= builderList.size()) {
                        builderList.add(new LineChart.Builder());
                    }
                    LineChart.Builder builder = (LineChart.Builder)builderList.get(i);
                    if (singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) {
                        builder.markFavorite(solverLabel);
                    }
                    builder.add(solverLabel, timeMillisSpent, levelValues[i]);
                }
            }
        }
        ArrayList<LineChart<Long, Double>> chartList = new ArrayList<LineChart<Long, Double>>(15);
        for (int scoreLevelIndex = 0; scoreLevelIndex < builderList.size(); ++scoreLevelIndex) {
            String scoreLevelLabel = this.problemBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
            LineChart chart = ((LineChart.Builder)builderList.get(scoreLevelIndex)).build("stepScoreProblemStatisticChart" + scoreLevelIndex, this.problemBenchmarkResult.getName() + " step " + scoreLevelLabel + " statistic", "Time spent", "Step " + scoreLevelLabel, true, true, false);
            chartList.add(chart);
        }
        return chartList;
    }
}

