/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.memoryuse;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.memoryuse.MemoryUseStatisticPoint;
import ai.timefold.solver.benchmark.impl.statistic.memoryuse.MemoryUseSubSingleStatistic;
import java.util.Collections;
import java.util.List;

public class MemoryUseProblemStatistic
extends ProblemStatistic<LineChart<Long, Long>> {
    private MemoryUseProblemStatistic() {
    }

    public MemoryUseProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.MEMORY_USE);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new MemoryUseSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    public List<String> getWarningList() {
        if (this.problemBenchmarkResult.getPlannerBenchmarkResult().hasMultipleParallelBenchmarks()) {
            return Collections.singletonList("This memory use statistic shows the sum of the memory of all benchmarks that ran in parallel, due to parallelBenchmarkCount (" + this.problemBenchmarkResult.getPlannerBenchmarkResult().getParallelBenchmarkCount() + ").");
        }
        return Collections.emptyList();
    }

    @Override
    protected List<LineChart<Long, Long>> generateCharts(BenchmarkReport benchmarkReport) {
        LineChart.Builder<Long, Long> builder = new LineChart.Builder<Long, Long>();
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            String solverLabel = singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix();
            if (singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) {
                builder.markFavorite(solverLabel);
            }
            if (!singleBenchmarkResult.hasAllSuccess()) continue;
            SubSingleStatistic subSingleStatistic = singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
            List points = subSingleStatistic.getPointList();
            for (MemoryUseStatisticPoint point : points) {
                long timeMillisSpent = point.getTimeMillisSpent();
                builder.add(solverLabel, timeMillisSpent, point.getUsedMemory() / 1024L / 1024L);
            }
        }
        return Collections.singletonList(builder.build("memoryUseProblemStatisticChart", this.problemBenchmarkResult.getName() + " memory use statistic", "Time spent", "Memory (MiB)", false, true, false));
    }
}

