/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class StatisticPoint {
    private static final Pattern DOUBLE_QUOTE = Pattern.compile("\"\"");
    private static final Pattern SINGLE_QUOTE = Pattern.compile("\"");

    public abstract String toCsvLine();

    public static String buildCsvLineWithLongs(long timeMillisSpent, long ... values) {
        Object[] array = Stream.concat(Stream.of(Long.valueOf(timeMillisSpent)), Arrays.stream(values).boxed()).toArray(Object[]::new);
        return StatisticPoint.buildCsvLine(array);
    }

    public static String buildCsvLineWithDoubles(long timeMillisSpent, double ... values) {
        Object[] array = Stream.concat(Stream.of(Long.valueOf(timeMillisSpent)), Arrays.stream(values).boxed()).toArray(Object[]::new);
        return StatisticPoint.buildCsvLine(array);
    }

    public static String buildCsvLineWithStrings(long timeMillisSpent, String ... values) {
        Object[] array = Stream.concat(Stream.of(Long.valueOf(timeMillisSpent)), Arrays.stream(values)).toArray(Object[]::new);
        return StatisticPoint.buildCsvLine(array);
    }

    public static String buildCsvLine(Object ... values) {
        return Arrays.stream(values).map(s -> {
            if (s instanceof Boolean) {
                Boolean bool = (Boolean)s;
                return bool != false ? "true" : "false";
            }
            if (s instanceof Integer) {
                Integer num = (Integer)s;
                return Integer.toString(num);
            }
            if (s instanceof Long) {
                Long num = (Long)s;
                return Long.toString(num);
            }
            return "\"" + SINGLE_QUOTE.matcher(s.toString()).replaceAll("\"\"") + "\"";
        }).collect(Collectors.joining(","));
    }

    public static List<String> parseCsvLine(String line) {
        String[] tokens = line.split(",");
        ArrayList<String> csvLine = new ArrayList<String>(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            Object token = tokens[i];
            while (((String)token).startsWith("\"") && !((String)token).endsWith("\"")) {
                if (++i >= tokens.length) {
                    throw new IllegalArgumentException("The CSV line (" + line + ") is not a valid CSV line.");
                }
                token = (String)token + "," + tokens[i];
            }
            if (((String)token).startsWith("\"") && ((String)token).endsWith("\"")) {
                token = ((String)token).substring(1, ((String)token).length() - 1);
                token = DOUBLE_QUOTE.matcher((CharSequence)token).replaceAll("\"");
            }
            csvLine.add((String)token);
        }
        return csvLine;
    }
}

