/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.statistic.common;

import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.LineChart;
import ai.timefold.solver.benchmark.impl.result.ProblemBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.statistic.ProblemStatistic;
import ai.timefold.solver.benchmark.impl.statistic.SubSingleStatistic;
import ai.timefold.solver.benchmark.impl.statistic.common.LongStatisticPoint;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTimeLineChartProblemStatistic
extends ProblemStatistic<LineChart<Long, Long>> {
    private final String reportFileName;
    private final String reportTitle;
    private final String yLabel;

    protected AbstractTimeLineChartProblemStatistic(ProblemStatisticType statisticType, ProblemBenchmarkResult<?> problemBenchmarkResult, String reportFileName, String reportTitle, String yLabel) {
        super(problemBenchmarkResult, statisticType);
        this.reportFileName = reportFileName;
        this.reportTitle = reportTitle;
        this.yLabel = yLabel;
    }

    @Override
    protected List<LineChart<Long, Long>> generateCharts(BenchmarkReport benchmarkReport) {
        LineChart.Builder<Long, Long> builder = new LineChart.Builder<Long, Long>();
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            String solverLabel = singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix();
            if (singleBenchmarkResult.hasAllSuccess()) {
                SubSingleStatistic subSingleStatistic = singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
                List points = subSingleStatistic.getPointList();
                for (LongStatisticPoint point : points) {
                    long timeMillisSpent = point.getTimeMillisSpent();
                    long calculationSpeed = point.getValue();
                    builder.add(solverLabel, timeMillisSpent, calculationSpeed);
                }
            }
            if (!singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) continue;
            builder.markFavorite(solverLabel);
        }
        return Collections.singletonList(builder.build(this.reportFileName, this.reportTitle, "Time spent", this.yLabel, false, true, false));
    }
}

