/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.ranking;

import ai.timefold.solver.benchmark.impl.ranking.SolverRankingWeightFactory;
import ai.timefold.solver.benchmark.impl.ranking.TotalScoreSingleBenchmarkRankingComparator;
import ai.timefold.solver.benchmark.impl.ranking.TotalScoreSolverRankingComparator;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class TotalRankSolverRankingWeightFactory
implements SolverRankingWeightFactory {
    private final Comparator<SingleBenchmarkResult> singleBenchmarkRankingComparator = new TotalScoreSingleBenchmarkRankingComparator();

    @Override
    public Comparable createRankingWeight(List<SolverBenchmarkResult> solverBenchmarkResultList, SolverBenchmarkResult solverBenchmarkResult) {
        int betterCount = 0;
        int equalCount = 0;
        int lowerCount = 0;
        List<SingleBenchmarkResult> singleBenchmarkResultList = solverBenchmarkResult.getSingleBenchmarkResultList();
        for (SingleBenchmarkResult single : singleBenchmarkResultList) {
            List<SingleBenchmarkResult> otherSingleList = single.getProblemBenchmarkResult().getSingleBenchmarkResultList();
            for (SingleBenchmarkResult otherSingle : otherSingleList) {
                if (single == otherSingle) continue;
                int scoreComparison = this.singleBenchmarkRankingComparator.compare(single, otherSingle);
                if (scoreComparison > 0) {
                    ++betterCount;
                    continue;
                }
                if (scoreComparison == 0) {
                    ++equalCount;
                    continue;
                }
                ++lowerCount;
            }
        }
        return new TotalRankSolverRankingWeight(solverBenchmarkResult, betterCount, equalCount, lowerCount);
    }

    public static class TotalRankSolverRankingWeight
    implements Comparable<TotalRankSolverRankingWeight> {
        private final Comparator<TotalRankSolverRankingWeight> totalRankSolverRankingWeightFactoryComparator = Comparator.comparingInt(TotalRankSolverRankingWeight::getBetterCount).thenComparingInt(TotalRankSolverRankingWeight::getEqualCount).thenComparingInt(TotalRankSolverRankingWeight::getLowerCount).thenComparing(TotalRankSolverRankingWeight::getSolverBenchmarkResult, new TotalScoreSolverRankingComparator());
        private final SolverBenchmarkResult solverBenchmarkResult;
        private final int betterCount;
        private final int equalCount;
        private final int lowerCount;

        public SolverBenchmarkResult getSolverBenchmarkResult() {
            return this.solverBenchmarkResult;
        }

        public int getBetterCount() {
            return this.betterCount;
        }

        public int getEqualCount() {
            return this.equalCount;
        }

        public int getLowerCount() {
            return this.lowerCount;
        }

        public TotalRankSolverRankingWeight(SolverBenchmarkResult solverBenchmarkResult, int betterCount, int equalCount, int lowerCount) {
            this.solverBenchmarkResult = solverBenchmarkResult;
            this.betterCount = betterCount;
            this.equalCount = equalCount;
            this.lowerCount = lowerCount;
        }

        @Override
        public int compareTo(TotalRankSolverRankingWeight other) {
            return this.totalRankSolverRankingWeightFactoryComparator.compare(this, other);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TotalRankSolverRankingWeight that = (TotalRankSolverRankingWeight)o;
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.betterCount, this.equalCount, this.lowerCount);
        }
    }
}

