/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl;

import ai.timefold.solver.benchmark.config.ProblemBenchmarksConfig;
import ai.timefold.solver.benchmark.config.SolverBenchmarkConfig;
import ai.timefold.solver.benchmark.config.statistic.ProblemStatisticType;
import ai.timefold.solver.benchmark.config.statistic.SingleStatisticType;
import ai.timefold.solver.benchmark.impl.DefaultPlannerBenchmarkFactory;
import ai.timefold.solver.benchmark.impl.ProblemBenchmarksFactory;
import ai.timefold.solver.benchmark.impl.result.PlannerBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.monitoring.MonitoringConfig;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SolverBenchmarkFactory {
    private final SolverBenchmarkConfig config;

    public SolverBenchmarkFactory(SolverBenchmarkConfig config) {
        this.config = config;
    }

    public <Solution_> void buildSolverBenchmark(ClassLoader classLoader, PlannerBenchmarkResult plannerBenchmark, Solution_[] extraProblems) {
        MonitoringConfig monitoringConfig;
        List monitoringSolverMetricList;
        this.validate();
        SolverBenchmarkResult solverBenchmarkResult = new SolverBenchmarkResult(plannerBenchmark);
        solverBenchmarkResult.setName(this.config.getName());
        solverBenchmarkResult.setSubSingleCount((Integer)ConfigUtils.inheritOverwritableProperty((Object)this.config.getSubSingleCount(), (Object)1));
        SolverConfig solverConfig = Objects.requireNonNullElseGet(this.config.getSolverConfig(), SolverConfig::new);
        if (solverConfig.getClassLoader() == null) {
            solverConfig.setClassLoader(classLoader);
        }
        List list = monitoringSolverMetricList = (monitoringConfig = solverConfig.getMonitoringConfig()) == null ? Collections.emptyList() : monitoringConfig.getSolverMetricList();
        if (monitoringConfig != null && monitoringSolverMetricList != null && !monitoringSolverMetricList.isEmpty()) {
            throw new IllegalArgumentException("The solverBenchmarkConfig (%s) has a %s (%s) with a non-empty %s (%s).".formatted(new Object[]{this.config, SolverConfig.class.getSimpleName(), solverConfig, MonitoringConfig.class.getSimpleName(), monitoringConfig}));
        }
        List<SolverMetric> solverMetricList = this.getSolverMetrics(this.config.getProblemBenchmarksConfig());
        solverBenchmarkResult.setSolverConfig(solverConfig.copyConfig().withMonitoringConfig(new MonitoringConfig().withSolverMetricList(solverMetricList)));
        DefaultSolverFactory defaultSolverFactory = new DefaultSolverFactory(solverConfig);
        SolutionDescriptor solutionDescriptor = defaultSolverFactory.getSolutionDescriptor();
        for (Solution_ extraProblem : extraProblems) {
            if (solutionDescriptor.getSolutionClass().isInstance(extraProblem)) continue;
            throw new IllegalArgumentException("The solverBenchmark name (%s) for solution class (%s) cannot solve a problem (%s) of class (%s).".formatted(this.config.getName(), solutionDescriptor.getSolutionClass(), extraProblem, extraProblem == null ? null : extraProblem.getClass()));
        }
        solverBenchmarkResult.setScoreDefinition(solutionDescriptor.getScoreDefinition());
        solverBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        ProblemBenchmarksConfig problemBenchmarksConfig = Objects.requireNonNullElseGet(this.config.getProblemBenchmarksConfig(), ProblemBenchmarksConfig::new);
        plannerBenchmark.getSolverBenchmarkResultList().add(solverBenchmarkResult);
        ProblemBenchmarksFactory problemBenchmarksFactory = new ProblemBenchmarksFactory(problemBenchmarksConfig);
        problemBenchmarksFactory.buildProblemBenchmarkList(solverBenchmarkResult, extraProblems);
    }

    protected void validate() {
        String configName = this.config.getName();
        if (configName == null || !DefaultPlannerBenchmarkFactory.VALID_NAME_PATTERN.matcher(configName).matches()) {
            throw new IllegalStateException("The solverBenchmark name (%s) is invalid because it does not follow the nameRegex (%s) which might cause an illegal filename.".formatted(configName, DefaultPlannerBenchmarkFactory.VALID_NAME_PATTERN.pattern()));
        }
        if (!configName.trim().equals(configName)) {
            throw new IllegalStateException("The solverBenchmark name (%s) is invalid because it starts or ends with whitespace.".formatted(configName));
        }
        Integer subSingleCount = this.config.getSubSingleCount();
        if (subSingleCount != null && subSingleCount < 1) {
            throw new IllegalStateException("The solverBenchmark name (%s) is invalid because the subSingleCount (%d) must be greater than 1.".formatted(configName, subSingleCount));
        }
    }

    protected List<SolverMetric> getSolverMetrics(ProblemBenchmarksConfig config) {
        ArrayList<SolverMetric> out = new ArrayList<SolverMetric>();
        for (ProblemStatisticType problemStatisticType : Optional.ofNullable(config).map(ProblemBenchmarksConfig::determineProblemStatisticTypeList).orElseGet(ProblemStatisticType::defaultList)) {
            if (problemStatisticType == ProblemStatisticType.SCORE_CALCULATION_SPEED) {
                out.add(SolverMetric.SCORE_CALCULATION_COUNT);
                continue;
            }
            if (problemStatisticType == ProblemStatisticType.MOVE_EVALUATION_SPEED) {
                out.add(SolverMetric.MOVE_EVALUATION_COUNT);
                continue;
            }
            out.add(SolverMetric.valueOf((String)problemStatisticType.name()));
        }
        for (SingleStatisticType singleStatisticType : Optional.ofNullable(config).map(ProblemBenchmarksConfig::determineSingleStatisticTypeList).orElseGet(Collections::emptyList)) {
            out.add(SolverMetric.valueOf((String)singleStatisticType.name()));
        }
        return out;
    }
}

