/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.speechtotext.models.streaming;

import java.util.ArrayList;
import java.util.List;

public class StreamContentType {
    private String contentType;
    private String layout;
    private Integer rate;
    private String format;
    private Integer channels;

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public Integer getRate() {
        return this.rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Integer getChannels() {
        return this.channels;
    }

    public void setChannels(Integer channels) {
        this.channels = channels;
    }

    public String buildContentString() {
        List<String> content = this.getListFromContentType();
        String empty = "";
        if (content.size() == 0) {
            return empty;
        }
        return this.createContentTypeParameter(content);
    }

    private List<String> getListFromContentType() {
        ArrayList<String> content = new ArrayList<String>();
        if (this.getContentType() != null) {
            content.add(this.getContentType());
        }
        if (this.getLayout() != null) {
            content.add("layout=" + this.getLayout());
        }
        if (this.getRate() != null) {
            content.add("rate=" + this.getRate());
        }
        if (this.getFormat() != null) {
            content.add("format=" + this.getFormat());
        }
        if (this.getChannels() != null) {
            content.add("channels=" + this.getChannels());
        }
        return content;
    }

    private String createContentTypeParameter(List<String> content) {
        return String.join((CharSequence)";", content);
    }
}

