/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.speechtotext;

import ai.rev.speechtotext.CustomVocabularyApiInterface;
import ai.rev.speechtotext.helpers.ClientHelper;
import ai.rev.speechtotext.models.vocabulary.CustomVocabularyInformation;
import ai.rev.speechtotext.models.vocabulary.CustomVocabularySubmission;
import java.io.IOException;
import java.util.List;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public class CustomVocabulariesClient {
    private OkHttpClient client;
    public CustomVocabularyApiInterface customVocabularyApiInterface;

    public CustomVocabulariesClient(String accessToken) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("Access token must be provided");
        }
        this.client = ClientHelper.createOkHttpClient(accessToken);
        Retrofit retrofit = ClientHelper.createRetrofitInstance(this.client);
        this.customVocabularyApiInterface = (CustomVocabularyApiInterface)retrofit.create(CustomVocabularyApiInterface.class);
    }

    public CustomVocabularyInformation submitCustomVocabularies(CustomVocabularySubmission submission) throws IOException {
        if (submission.getCustomVocabularies() == null || submission.getCustomVocabularies().isEmpty()) {
            throw new IllegalArgumentException("Custom vocabularies must be provided");
        }
        return (CustomVocabularyInformation)this.customVocabularyApiInterface.submitCustomVocabularies(submission).execute().body();
    }

    public List<CustomVocabularyInformation> getListOfCustomVocabularyInformation() throws IOException {
        return (List)this.customVocabularyApiInterface.getListOfCustomVocabularyInformation().execute().body();
    }

    public CustomVocabularyInformation getCustomVocabularyInformation(String id) throws IOException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Custom vocabulary Id must be provided");
        }
        return (CustomVocabularyInformation)this.customVocabularyApiInterface.getCustomVocabularyInformation(id).execute().body();
    }

    public void deleteCustomVocabulary(String id) throws IOException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Custom vocabulary Id must be provided");
        }
        this.customVocabularyApiInterface.deleteCustomVocabulary(id).execute().body();
    }
}

