/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding.interaction;

import ai.h2o.targetencoding.interaction.InteractionsEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.NewChunk;

class CreateInteractionTask
extends MRTask<CreateInteractionTask> {
    final InteractionsEncoder _encoder;
    final long[] _interactionDomain;
    private transient Map<Long, Integer> _interactionValueToCategoricalValue;

    public CreateInteractionTask(InteractionsEncoder encoder, String[] interactionDomain) {
        this._encoder = encoder;
        this._interactionDomain = interactionDomain == null ? null : Arrays.stream(interactionDomain).mapToLong(Long::parseLong).toArray();
    }

    protected void setupLocal() {
        if (this._interactionDomain != null) {
            this._interactionValueToCategoricalValue = new HashMap<Long, Integer>();
            for (int i = 0; i < this._interactionDomain.length; ++i) {
                this._interactionValueToCategoricalValue.put(this._interactionDomain[i], i);
            }
        }
    }

    public void map(Chunk[] cs, NewChunk nc) {
        for (int row = 0; row < cs[0].len(); ++row) {
            int[] interactingValues = new int[cs.length];
            for (int i = 0; i < cs.length; ++i) {
                interactingValues[i] = cs[i].isNA(row) ? -1 : (int)cs[i].at8(row);
            }
            long val = this._encoder.encode(interactingValues);
            if (val < 0L) {
                nc.addNA();
                continue;
            }
            if (this._interactionDomain == null) {
                nc.addNum((double)val);
                continue;
            }
            int catVal = this._interactionValueToCategoricalValue.getOrDefault(val, -1);
            if (catVal < 0) {
                nc.addNA();
                continue;
            }
            nc.addCategorical(catVal);
        }
    }
}

