/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoderModel;
import hex.Model;
import hex.ModelPreprocessor;
import java.util.Objects;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.fvec.Frame;

public class TargetEncoderPreprocessor
extends ModelPreprocessor<TargetEncoderPreprocessor> {
    private TargetEncoderModel _targetEncoder;

    public TargetEncoderPreprocessor(TargetEncoderModel targetEncoder) {
        super(Key.make((String)(Objects.toString(targetEncoder._key) + "_preprocessor")));
        this._targetEncoder = targetEncoder;
        DKV.put((Keyed)this);
    }

    public Frame processTrain(Frame fr, Model.Parameters params) {
        if (this.useFoldTransform(params)) {
            return this._targetEncoder.transformTraining(fr, params._cv_fold);
        }
        return this._targetEncoder.transformTraining(fr);
    }

    public Frame processValid(Frame fr, Model.Parameters params) {
        if (this.useFoldTransform(params)) {
            return this._targetEncoder.transformTraining(fr);
        }
        return this._targetEncoder.transform(fr);
    }

    public Frame processScoring(Frame fr, Model model) {
        return this._targetEncoder.transform(fr);
    }

    public Model asModel() {
        return this._targetEncoder;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (cascade && this._targetEncoder != null) {
            this._targetEncoder.remove();
        }
        return super.remove_impl(fs, cascade);
    }

    private boolean useFoldTransform(Model.Parameters params) {
        return params._is_cv_model && ((TargetEncoderModel.TargetEncoderParameters)this._targetEncoder._parms)._data_leakage_handling == TargetEncoderModel.DataLeakageHandlingStrategy.KFold;
    }
}

