/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.BaseModel;
import ai.djl.Device;
import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.nn.Block;
import ai.djl.tensorflow.engine.TfNDManager;
import ai.djl.tensorflow.engine.TfSymbolBlock;
import ai.djl.training.Trainer;
import ai.djl.training.TrainingConfig;
import ai.djl.translate.Translator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.proto.framework.ConfigProto;
import org.tensorflow.proto.framework.RunOptions;

public class TfModel
extends BaseModel {
    private AtomicBoolean first;
    private NDManager manager;

    TfModel(String name, Device device) {
        super(name);
        device = Device.defaultIfNull((Device)device);
        this.properties = new ConcurrentHashMap();
        this.manager = TfNDManager.getSystemManager().newSubManager(device);
        this.first = new AtomicBoolean(true);
    }

    public void load(Path modelPath, String prefix, Map<String, Object> options) throws FileNotFoundException {
        Path exportDir;
        this.modelDir = modelPath.toAbsolutePath();
        if (prefix == null) {
            prefix = this.modelName;
        }
        if ((exportDir = this.findModelDir(prefix)) == null && (exportDir = this.findModelDir("saved_model.pb")) == null) {
            throw new FileNotFoundException("No TensorFlow model found in: " + this.modelDir);
        }
        String[] tags = null;
        ConfigProto proto = null;
        RunOptions runOptions = null;
        String signatureDefKey = "serving_default";
        if (options != null) {
            tags = (String[])options.get("Tags");
            proto = (ConfigProto)options.get("ConfigProto");
            runOptions = (RunOptions)options.get("RunOptions");
            signatureDefKey = (String)options.get("SignatureDefKey");
        }
        if (tags == null) {
            tags = new String[]{"serve"};
        }
        SavedModelBundle.Loader loader = SavedModelBundle.loader((String)exportDir.toString()).withTags(tags);
        if (proto != null) {
            loader.withConfigProto(proto);
        }
        if (runOptions != null) {
            loader.withRunOptions(runOptions);
        }
        SavedModelBundle bundle = loader.load();
        this.block = new TfSymbolBlock(bundle, signatureDefKey);
    }

    private Path findModelDir(String prefix) {
        Path file;
        Path path = this.modelDir.resolve(prefix);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return this.modelDir;
        }
        if (Files.isDirectory(path, new LinkOption[0]) && Files.exists(file = path.resolve("saved_model.pb"), new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    public void save(Path modelPath, String newModelName) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public Trainer newTrainer(TrainingConfig trainingConfig) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public <I, O> Predictor<I, O> newPredictor(Translator<I, O> translator) {
        return new Predictor((Model)this, translator, this.first.getAndSet(false));
    }

    public NDManager getNDManager() {
        return this.manager;
    }

    public String[] getArtifactNames() {
        try {
            List files = Files.walk(this.modelDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            ArrayList<String> ret = new ArrayList<String>(files.size());
            for (Path path : files) {
                String fileName = path.toFile().getName();
                if (fileName.endsWith(".pb")) continue;
                Path relative = this.modelDir.relativize(path);
                ret.add(relative.toString());
            }
            return ret.toArray(new String[0]);
        }
        catch (IOException e) {
            throw new AssertionError("Failed list files", e);
        }
    }

    public void cast(DataType dataType) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void close() {
        this.manager.close();
        if (this.block != null) {
            this.block.clear();
        }
    }
}

