/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "jnitensorflow";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-\\w)?)(-SNAPSHOT)?(-\\d+)?");
    private static final String[] SUPPORTED_CUDA_VERSIONS = new String[]{"cu102", "cu101", "cu100", "cu92"};

    private LibUtils() {
    }

    public static void loadLibrary() {
        String libName = LibUtils.getTensorFlowLib();
        if (libName != null) {
            logger.debug("Loading TensorFlow library from: {}", (Object)libName);
            String path = new File(libName).getParentFile().toString();
            System.setProperty("org.bytedeco.javacpp.platform.preloadpath", path);
        }
    }

    private static String getTensorFlowLib() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("native/lib/tensorflow.properties");
        if (url == null) {
            logger.debug("tensorflow.properties not found in class path.");
            return null;
        }
        try {
            Platform platform = Platform.fromUrl((URL)url);
            return LibUtils.downloadTensorFlow(platform);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to download TensorFlow native library", e);
        }
    }

    /*
     * Loose catch block
     */
    private static String downloadTensorFlow(Platform platform) throws IOException {
        String version = platform.getVersion();
        String os = platform.getOsPrefix();
        String classifier = platform.getClassifier();
        String cudaArch = platform.getCudaArch();
        String flavor = platform.getFlavor();
        if (flavor.isEmpty()) {
            flavor = "cpu";
        } else if (Arrays.asList(SUPPORTED_CUDA_VERSIONS).contains(flavor)) {
            flavor = "gpu";
        } else {
            logger.warn("Unsupported GPU platform: {}, fallback to CPU.", (Object)flavor);
            flavor = "cpu";
        }
        String libName = System.mapLibraryName(LIB_NAME);
        Path cacheDir = LibUtils.getCacheDir();
        logger.debug("Using cache dir: {}", (Object)cacheDir);
        Path dir = cacheDir.resolve(version + '-' + flavor + '-' + classifier);
        Path path = dir.resolve(libName);
        if (Files.exists(path, new LinkOption[0])) {
            return path.toAbsolutePath().toString();
        }
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        Path tmp = Files.createTempDirectory(cacheDir, "tmp", new FileAttribute[0]);
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected version: " + version);
        }
        String link = "https://djl-ai.s3.amazonaws.com/publish/tensorflow-" + matcher.group(1);
        try {
            String string;
            try (InputStream is = new URL(link + "/files.txt").openStream();){
                List lines = Utils.readLines((InputStream)is);
                boolean found = LibUtils.downloadFiles(lines, link, os, flavor, tmp);
                if (!found && cudaArch != null) {
                    flavor = "cpu";
                    dir = cacheDir.resolve(version + '-' + flavor + '-' + classifier);
                    path = dir.resolve(libName);
                    if (Files.exists(path, new LinkOption[0])) {
                        logger.warn("No matching CUDA flavor for {} found: {}/sm_{}, fallback to CPU.", new Object[]{os, flavor, cudaArch});
                        String string2 = path.toAbsolutePath().toString();
                        return string2;
                    }
                    found = LibUtils.downloadFiles(lines, link, os, flavor, tmp);
                }
                if (!found) {
                    throw new UnsupportedOperationException("TensorFlow engine does not support this platform: " + os);
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
            }
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tmp != null) {
                Utils.deleteQuietly((Path)tmp);
            }
        }
    }

    private static boolean downloadFiles(List<String> lines, String link, String os, String flavor, Path tmp) throws IOException {
        boolean found = false;
        for (String line : lines) {
            if (!line.startsWith(os + '/' + flavor + '/')) continue;
            found = true;
            URL url = new URL(link + '/' + line.replace("+", "%2B"));
            String fileName = line.substring(line.lastIndexOf(47) + 1, line.length() - 3);
            logger.info("Downloading {} ...", (Object)fileName);
            GZIPInputStream fis = new GZIPInputStream(url.openStream());
            Throwable throwable = null;
            try {
                Files.copy(fis, tmp.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fis == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)fis).close();
            }
        }
        return found;
    }

    private static Path getCacheDir() {
        String cacheDir = System.getProperty("ENGINE_CACHE_DIR");
        if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("ENGINE_CACHE_DIR")) == null || cacheDir.isEmpty())) {
            cacheDir = System.getProperty("DJL_CACHE_DIR");
            if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("DJL_CACHE_DIR")) == null || cacheDir.isEmpty())) {
                String userHome = System.getProperty("user.home");
                return Paths.get(userHome, ".tensorflow/cache");
            }
            return Paths.get(cacheDir, "tensorflow");
        }
        return Paths.get(cacheDir, ".tensorflow/cache");
    }
}

