/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.NDUtils;
import ai.djl.ndarray.index.NDArrayIndexer;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.nn.recurrent.RNN;
import ai.djl.tensorflow.engine.TfNDArray;
import ai.djl.tensorflow.engine.TfNDArrayIndexer;
import ai.djl.tensorflow.engine.TfNDManager;
import java.util.List;
import org.tensorflow.internal.c_api.TFE_TensorHandle;

public class TfNDArrayEx
implements NDArrayEx {
    private NDArrayIndexer indexer;
    private TfNDArray array;
    private TfNDManager manager;

    TfNDArrayEx(TfNDArray array) {
        this.array = array;
        this.manager = array.getManager();
        this.indexer = new TfNDArrayIndexer(this.manager);
    }

    public NDArray rdiv(Number n) {
        return this.rdiv(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rdiv(NDArray b) {
        return b.div((NDArray)this.array);
    }

    public NDArray rdivi(Number n) {
        return this.rdivi(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rdivi(NDArray b) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Div").addInput(b).addInput(this.array).buildRawPointer(1)[0];
        this.array.setHandle(newHandle);
        return this.array;
    }

    public NDArray rsub(Number n) {
        return this.rsub(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rsub(NDArray b) {
        return b.sub((NDArray)this.array);
    }

    public NDArray rsubi(Number n) {
        return this.rsubi(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rsubi(NDArray b) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Sub").addInput(b).addInput(this.array).buildRawPointer(1)[0];
        this.array.setHandle(newHandle);
        return this.array;
    }

    public NDArray rmod(Number n) {
        return this.rmod(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rmod(NDArray b) {
        return b.mod((NDArray)this.array);
    }

    public NDArray rmodi(Number n) {
        return this.rmodi(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rmodi(NDArray b) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Mod").addInput(b).addInput(this.array).buildRawPointer(1)[0];
        this.array.setHandle(newHandle);
        return this.array;
    }

    public NDArray rpow(Number n) {
        return this.manager.create(n).toType(this.array.getDataType(), false).pow((NDArray)this.array);
    }

    /*
     * Exception decompiling
     */
    public NDArray rpowi(Number n) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray relu() {
        return this.manager.opExecutor("Relu").addInput(this.array).buildSingletonOrThrow();
    }

    public NDArray sigmoid() {
        return this.manager.opExecutor("Sigmoid").addInput(this.array).buildSingletonOrThrow();
    }

    public NDArray tanh() {
        return this.array.tanh();
    }

    public NDArray softPlus() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray softSign() {
        return this.manager.opExecutor("Softsign").addInput(this.array).buildSingletonOrThrow();
    }

    public NDArray leakyRelu(float alpha) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray elu(float alpha) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray selu() {
        return this.manager.opExecutor("Selu").addInput(this.array).buildSingletonOrThrow();
    }

    public NDArray gelu() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray maxPool(Shape kernelShape, Shape stride, Shape padding, boolean ceilMode) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray globalMaxPool() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray avgPool(Shape kernelShape, Shape stride, Shape padding, boolean ceilMode, boolean countIncludePad) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray globalAvgPool() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray lpPool(float normType, Shape kernelShape, Shape stride, Shape padding, boolean ceilMode) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray globalLpPool(float normType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void adadeltaUpdate(NDList inputs, NDList weights, float weightDecay, float rescaleGrad, float clipGrad, float rho, float epsilon) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void adagradUpdate(NDList inputs, NDList weights, float learningRate, float weightDecay, float rescaleGrad, float clipGrad, float epsilon) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void adamUpdate(NDList inputs, NDList weights, float learningRate, float weightDecay, float rescaleGrad, float clipGrad, float beta1, float beta2, float epsilon, boolean lazyUpdate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void nagUpdate(NDList inputs, NDList weights, float learningRate, float weightDecay, float rescaleGrad, float clipGrad, float momentum) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void rmspropUpdate(NDList inputs, NDList weights, float learningRate, float weightDecay, float rescaleGrad, float clipGrad, float rho, float momentum, float epsilon, boolean centered) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void sgdUpdate(NDList inputs, NDList weights, float learningRate, float weightDecay, float rescaleGrad, float clipGrad, float momentum, boolean lazyUpdate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList convolution(NDArray input, NDArray weight, NDArray bias, Shape stride, Shape padding, Shape dilation, int groups) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList deconvolution(NDArray input, NDArray weight, NDArray bias, Shape stride, Shape padding, Shape outPadding, Shape dilation, int groups) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList linear(NDArray input, NDArray weight, NDArray bias) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList embedding(NDArray input, NDArray weight, SparseFormat sparse) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList prelu(NDArray input, NDArray alpha) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList dropout(NDArray input, float rate, boolean training) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList layerNorm(NDArray input, Shape normalizedShape, NDArray gamma, NDArray beta, float eps) {
        throw new UnsupportedOperationException();
    }

    public NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar, NDArray gamma, NDArray beta, int axis, float momentum, float eps, boolean training) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList rnn(NDArray input, NDArray state, NDList params, boolean hasBiases, int numLayers, RNN.Activation activation, double dropRate, boolean train, boolean bidirectional, boolean batchFirst) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList gru(NDArray input, NDArray state, NDList params, boolean hasBiases, int numLayers, double dropRate, boolean training, boolean bidirectional, boolean batchFirst) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList lstm(NDArray input, NDList states, NDList params, boolean hasBiases, int numLayers, double dropRate, boolean training, boolean bidirectional, boolean batchFirst) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * Exception decompiling
     */
    public NDArray normalize(float[] mean, float[] std) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray toTensor() {
        try (TfNDManager subManager = (TfNDManager)this.array.getManager().newSubManager();){
            this.array.attach((NDManager)subManager);
            TfNDArray input = this.array;
            int dim = input.getShape().dimension();
            if (dim == 3) {
                input = input.expandDims(0);
            }
            input = input.div(255.0);
            if (dim == 3) {
                input = input.squeeze(0);
            }
            TfNDArray output = !input.getDataType().equals((Object)DataType.FLOAT32) ? input.toType(DataType.FLOAT32, false) : input;
            this.array.attach(subManager.getParentManager());
            output.attach(subManager.getParentManager());
            TfNDArray tfNDArray = output;
            return tfNDArray;
        }
    }

    /*
     * Exception decompiling
     */
    public NDArray resize(int width, int height, int interpolation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray randomFlipLeftRight() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray randomFlipTopBottom() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray randomBrightness(float brightness) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray randomHue(float hue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray randomColorJitter(float brightness, float contrast, float saturation, float hue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArrayIndexer getIndexer() {
        return this.indexer;
    }

    public NDArray where(NDArray condition, NDArray other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray stack(NDList arrays) {
        return this.stack(arrays, 0);
    }

    public NDArray stack(NDList arrays, int axis) {
        NDArray[] srcArray = new NDArray[arrays.size() + 1];
        srcArray[0] = this.array;
        System.arraycopy(arrays.toArray((Object[])new NDArray[0]), 0, srcArray, 1, arrays.size());
        return this.manager.opExecutor("Pack").addInputList(srcArray).addParam("axis", axis).buildSingletonOrThrow();
    }

    public NDArray concat(NDList arrays, int axis) {
        NDUtils.checkConcatInput((NDList)arrays);
        NDArray[] srcArray = new NDArray[arrays.size() + 1];
        srcArray[0] = this.array;
        System.arraycopy(arrays.toArray((Object[])new NDArray[0]), 0, srcArray, 1, arrays.size());
        try (NDArray axisArr = this.manager.create(axis);){
            NDArray nDArray = this.manager.opExecutor("ConcatV2").addInputList(srcArray).addInput(axisArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDList multiBoxTarget(NDList inputs, float iouThreshold, float ignoreLabel, float negativeMiningRatio, float negativeMiningThreshold, int minNegativeSamples) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList multiBoxPrior(List<Float> sizes, List<Float> ratios, List<Float> steps, List<Float> offsets, boolean clip) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList multiBoxDetection(NDList inputs, boolean clip, float threshold, int backgroundId, float nmsThreshold, boolean forceSuppress, int nmsTopK) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray getArray() {
        return this.array;
    }

    private String getResizeOpName(int interpolate) {
        switch (interpolate) {
            case 0: {
                return "ResizeNearestNeighbor";
            }
            case 1: {
                return "ResizeBilinear";
            }
            case 2: {
                return "ResizeArea";
            }
            case 3: {
                return "ResizeBicubic";
            }
        }
        throw new UnsupportedOperationException("The kind of interpolation is not supported.");
    }
}

