/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.Device;
import ai.djl.engine.EngineException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.tensorflow.engine.TfDataType;
import ai.djl.tensorflow.engine.TfNDArrayEx;
import ai.djl.tensorflow.engine.TfNDManager;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.tensorflow.Operand;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.BroadcastTo;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Gather;
import org.tensorflow.op.core.Max;
import org.tensorflow.op.core.Min;
import org.tensorflow.op.core.Prod;
import org.tensorflow.op.core.Range;
import org.tensorflow.op.core.ReduceAll;
import org.tensorflow.op.core.ReduceAny;
import org.tensorflow.op.core.Squeeze;
import org.tensorflow.op.core.Sum;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.linalg.EuclideanNorm;
import org.tensorflow.op.linalg.MatMul;
import org.tensorflow.op.linalg.Transpose;
import org.tensorflow.op.math.Cumsum;
import org.tensorflow.op.math.Equal;
import org.tensorflow.op.math.Mean;
import org.tensorflow.op.math.NotEqual;
import org.tensorflow.op.nn.LogSoftmax;
import org.tensorflow.op.nn.TopK;
import org.tensorflow.op.train.BatchMatMul;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public class TfNDArray
implements NDArray {
    private static final int MAX_SIZE = 100;
    private static final int MAX_DEPTH = 10;
    private static final int MAX_ROWS = 10;
    private static final int MAX_COLUMNS = 20;
    private static final int MAX_OUTPUTS_PER_OP = 1000;
    private String uid;
    private ai.djl.ndarray.types.Shape shape;
    private TfNDManager manager;
    private Ops tf;
    private Operand<?> operand;
    private String name = "";
    private TfNDArrayEx tfNDArrayEx;
    private DataType dataType;

    TfNDArray(NDManager manager, Tensor<?> tensor) {
        this.manager = (TfNDManager)manager;
        this.tf = this.manager.getTf();
        this.uid = UUID.randomUUID().toString();
        manager.attach(this.uid, (AutoCloseable)((Object)this));
        this.operand = this.manager.getEagerSession().opBuilder("Const", "Const_" + TfNDManager.nextNameAssignment()).setAttr("dtype", tensor.dataType()).setAttr("value", tensor).setDevice(this.getTfDevice()).build().output(0);
        this.shape = new ai.djl.ndarray.types.Shape(tensor.shape().asArray());
        this.dataType = TfDataType.fromTf((org.tensorflow.DataType<? extends TType>)tensor.dataType());
        this.tfNDArrayEx = new TfNDArrayEx(this);
    }

    public NDManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String getUid() {
        return this.uid;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Device getDevice() {
        return this.manager.getDevice();
    }

    public ai.djl.ndarray.types.Shape getShape() {
        return this.shape;
    }

    public SparseFormat getSparseFormat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isSparse() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray toDevice(Device device, boolean copy) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray toType(DataType dataType, boolean copy) {
        Cast output = this.tf.dtypes.cast(this.getOperand(), TfDataType.toTf(dataType), new Cast.Options[0]);
        if (copy) {
            output = this.tf.deepCopy((Operand)output);
        }
        try (Tensor tensor = output.asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public void attachGradient() {
    }

    public void attachGradient(SparseFormat sparseFormat) {
    }

    public NDArray getGradient() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasGradient() {
        return false;
    }

    public NDArray stopGradient() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public double[] toDoubleArray() {
        if (this.getDataType() != DataType.FLOAT64) {
            throw new IllegalStateException("DataType mismatch, Required double Actual " + this.getDataType());
        }
        double[] result = new double[(int)this.getShape().size()];
        try (Tensor tensor = this.operand.asTensor();){
            tensor.rawData().asDoubles().read(result);
        }
        return result;
    }

    public float[] toFloatArray() {
        if (this.getDataType() != DataType.FLOAT32) {
            throw new IllegalStateException("DataType mismatch, Required float, Actual " + this.getDataType());
        }
        float[] result = new float[(int)this.getShape().size()];
        try (Tensor tensor = this.operand.asTensor();){
            tensor.rawData().asFloats().read(result);
        }
        return result;
    }

    public int[] toIntArray() {
        if (this.getDataType() != DataType.INT32) {
            throw new IllegalStateException("DataType mismatch, Required int Actual " + this.getDataType());
        }
        int[] result = new int[(int)this.getShape().size()];
        try (Tensor tensor = this.operand.asTensor();){
            tensor.rawData().asInts().read(result);
        }
        return result;
    }

    public long[] toLongArray() {
        if (this.getDataType() != DataType.INT64) {
            throw new IllegalStateException("DataType mismatch, Required long Actual " + this.getDataType());
        }
        long[] result = new long[(int)this.getShape().size()];
        try (Tensor tensor = this.operand.asTensor();){
            tensor.rawData().asLongs().read(result);
        }
        return result;
    }

    public boolean[] toBooleanArray() {
        if (this.getDataType() != DataType.BOOLEAN) {
            throw new IllegalStateException("DataType mismatch, Required boolean Actual " + this.getDataType());
        }
        boolean[] result = new boolean[(int)this.getShape().size()];
        try (Tensor tensor = this.operand.asTensor();){
            tensor.rawData().asBooleans().read(result);
        }
        return result;
    }

    public ByteBuffer toByteBuffer() {
        ai.djl.ndarray.types.Shape sh = this.getShape();
        DataType dType = this.getDataType();
        long product = sh.size();
        long len = (long)dType.getNumOfBytes() * product;
        byte[] buf = new byte[Math.toIntExact(len)];
        try (Tensor tensor = this.operand.asTensor();){
            tensor.rawData().read(buf);
        }
        return ByteBuffer.wrap(buf);
    }

    public void set(Buffer data) {
        throw new UnsupportedOperationException("Tensor cannot be modified after creation");
    }

    public NDManager attach(NDManager manager) {
        this.detach();
        TfNDManager original = this.manager;
        this.manager = (TfNDManager)manager;
        manager.attach(this.uid, (AutoCloseable)((Object)this));
        return original;
    }

    public void detach() {
        this.manager.detach(this.getUid());
        this.manager = TfNDManager.getSystemManager();
    }

    public void copyTo(NDArray ndArray) {
        if (!(ndArray instanceof TfNDArray)) {
            throw new IllegalArgumentException("Only TfNDArray is supported.");
        }
        ai.djl.ndarray.types.Shape inShape = this.getShape();
        ai.djl.ndarray.types.Shape destShape = ndArray.getShape();
        if (!Arrays.equals(inShape.getShape(), destShape.getShape())) {
            throw new IllegalArgumentException("shape are diff. Required: " + destShape + ", Actual " + inShape);
        }
        ((TfNDArray)ndArray).operand = this.tf.deepCopy(this.getOperand()).asOutput();
        ((TfNDArray)ndArray).dataType = this.getDataType();
        ((TfNDArray)ndArray).shape = new ai.djl.ndarray.types.Shape(this.getShape().stream().mapToLong(pair -> (Long)pair.getKey()).toArray());
    }

    public NDArray booleanMask(NDArray index, int axis) {
        if (this.isScalar()) {
            if (!index.isScalar()) {
                throw new IllegalArgumentException("Input is scalar, index must also be scalar.");
            }
            if (index.toBooleanArray()[0]) {
                return this.expandDims(0);
            }
            return this.manager.create(new ai.djl.ndarray.types.Shape(new long[0]));
        }
        try (Tensor tensor = this.tf.gather(this.getOperand(), (Operand)this.tf.squeeze((Operand)this.tf.where(((TfNDArray)index).getOperand()), new Squeeze.Options[]{Squeeze.axis(Collections.singletonList(1L))}), (Operand)this.tf.constant(axis), new Gather.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray sequenceMask(NDArray sequenceLength, float value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public NDArray sequenceMask(NDArray sequenceLength) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public NDArray zerosLike() {
        try (Tensor tensor = this.tf.zerosLike(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray onesLike() {
        try (Tensor tensor = this.tf.onesLike(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public boolean contentEquals(Number number) {
        if (number == null) {
            return false;
        }
        try (NDArray result = this.eq(number);){
            boolean bl = result.all().getBoolean(new long[0]);
            return bl;
        }
    }

    public boolean contentEquals(NDArray other) {
        if (other == null || !this.shapeEquals(other)) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        TfNDArray eq = (TfNDArray)this.eq(other);
        return eq.all().toBooleanArray()[0];
    }

    public NDArray eq(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.eq(number);
            return nDArray;
        }
    }

    public NDArray eq(NDArray other) {
        try (Tensor tensor = this.tf.math.equal(this.getOperand(), ((TfNDArray)other).getOperand(), new Equal.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray neq(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.neq(number);
            return nDArray;
        }
    }

    public NDArray neq(NDArray other) {
        try (Tensor tensor = this.tf.math.notEqual(this.getOperand(), ((TfNDArray)other).getOperand(), new NotEqual.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray gt(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.gt(number);
            return nDArray;
        }
    }

    public NDArray gt(NDArray other) {
        try (Tensor tensor = this.tf.math.greater(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray gte(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.gte(number);
            return nDArray;
        }
    }

    public NDArray gte(NDArray other) {
        try (Tensor tensor = this.tf.math.greaterEqual(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray lt(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.lt(number);
            return nDArray;
        }
    }

    public NDArray lt(NDArray other) {
        try (Tensor tensor = this.tf.math.less(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray lte(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.lte(number);
            return nDArray;
        }
    }

    public NDArray lte(NDArray other) {
        try (Tensor tensor = this.tf.math.lessEqual(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray all() {
        try (Tensor tensor = this.tf.reduceAll((Operand)this.tf.dtypes.cast(this.getOperand(), TBool.DTYPE, new Cast.Options[0]), (Operand)this.tf.range((Operand)this.tf.constant(0L), (Operand)this.tf.constant((long)this.getRank()), (Operand)this.tf.constant(1L)), new ReduceAll.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray any() {
        try (Tensor tensor = this.tf.reduceAny((Operand)this.tf.dtypes.cast(this.getOperand(), TBool.DTYPE, new Cast.Options[0]), (Operand)this.tf.range((Operand)this.tf.constant(0L), (Operand)this.tf.constant((long)this.getRank()), (Operand)this.tf.constant(1L)), new ReduceAny.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray erfinv() {
        try (Tensor tensor = this.tf.math.erfinv(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray norm(boolean keepDims) {
        if (this.dataType == DataType.FLOAT64) {
            throw new UnsupportedOperationException("float64 is not supported");
        }
        TfNDArray flattenTensor = (TfNDArray)this.flatten();
        try (Tensor tensor = this.tf.linalg.euclideanNorm(flattenTensor.getOperand(), (Operand)this.tf.constant(0), new EuclideanNorm.Options[0]).asTensor();){
            flattenTensor.close();
            if (!keepDims) {
                TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
                return tfNDArray;
            }
            float number = tensor.rawData().asFloats().getFloat(0L);
            long[] shapes = LongStream.generate(() -> 1L).limit(this.shape.dimension()).toArray();
            NDArray nDArray = this.manager.create(new float[]{number}, new ai.djl.ndarray.types.Shape(shapes));
            return nDArray;
        }
    }

    public NDArray norm(int ord, int[] axes, boolean keepDims) {
        if (ord != 2) {
            throw new UnsupportedOperationException("Only ord=2 is supported");
        }
        try (Tensor tensor = this.tf.linalg.euclideanNorm(this.getOperand(), (Operand)this.tf.constant(axes), new EuclideanNorm.Options[]{EuclideanNorm.keepDims((Boolean)keepDims)}).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray add(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.add(number);
            return nDArray;
        }
    }

    public NDArray add(NDArray other) {
        try (Tensor tensor = this.tf.math.add(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray sub(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.sub(number);
            return nDArray;
        }
    }

    public NDArray sub(NDArray other) {
        try (Tensor tensor = this.tf.math.sub(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray mul(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.mul(number);
            return nDArray;
        }
    }

    public NDArray mul(NDArray other) {
        try (Tensor tensor = this.tf.math.mul(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray div(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.div(number);
            return nDArray;
        }
    }

    public NDArray div(NDArray other) {
        try (Tensor tensor = this.tf.math.div(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray mod(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.mod(number);
            return nDArray;
        }
    }

    public NDArray mod(NDArray other) {
        try (Tensor tensor = this.tf.math.mod(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray pow(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.pow(number);
            return nDArray;
        }
    }

    public NDArray pow(NDArray other) {
        try (Tensor tensor = this.tf.math.pow(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray maximum(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.maximum(number);
            return nDArray;
        }
    }

    public NDArray maximum(NDArray other) {
        try (Tensor tensor = this.tf.math.maximum(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray minimum(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.minimum(number);
            return nDArray;
        }
    }

    public NDArray minimum(NDArray other) {
        try (Tensor tensor = this.tf.math.minimum(this.getOperand(), ((TfNDArray)other).getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray addi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.addi(number);
            return nDArray;
        }
    }

    public NDArray addi(NDArray other) {
        return this.inPlaceHelper(this.add(other), this);
    }

    public NDArray subi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.subi(number);
            return nDArray;
        }
    }

    public NDArray subi(NDArray other) {
        return this.inPlaceHelper(this.sub(other), this);
    }

    public NDArray muli(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.muli(number);
            return nDArray;
        }
    }

    public NDArray muli(NDArray other) {
        return this.inPlaceHelper(this.mul(other), this);
    }

    public NDArray divi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.divi(number);
            return nDArray;
        }
    }

    public NDArray divi(NDArray other) {
        return this.inPlaceHelper(this.div(other), this);
    }

    NDArray inPlaceHelper(NDArray source, NDArray destination) {
        if (this.getShape().isScalar()) {
            throw new UnsupportedOperationException("TensorFlow engine does not support inplace operations on scalars yet");
        }
        Range indices = this.tf.range((Operand)this.tf.constant(0), (Operand)this.tf.constant((int)this.getShape().getShape()[0]), (Operand)this.tf.constant(1));
        ((TfNDArray)destination).setOperand((Operand<?>)this.tf.inplaceUpdate(((TfNDArray)destination).getOperand(), (Operand)indices, ((TfNDArray)source).getOperand()).asOutput());
        return destination;
    }

    public NDArray toSparse(SparseFormat fmt) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray modi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.modi(number);
            return nDArray;
        }
    }

    public NDArray modi(NDArray other) {
        return this.inPlaceHelper(this.mod(other), this);
    }

    public NDArray powi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.powi(number);
            return nDArray;
        }
    }

    public NDArray powi(NDArray other) {
        return this.inPlaceHelper(this.pow(other), this);
    }

    public NDArray sign() {
        try (Tensor tensor = this.tf.math.sign(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray signi() {
        return this.inPlaceHelper(this.sign(), this);
    }

    public NDArray neg() {
        try (Tensor tensor = this.tf.math.neg(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray negi() {
        return this.inPlaceHelper(this.neg(), this);
    }

    public NDArray abs() {
        try (Tensor tensor = this.tf.math.abs(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray square() {
        try (Tensor tensor = this.tf.math.square(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray sqrt() {
        try (Tensor tensor = this.tf.math.sqrt(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray cbrt() {
        try (Tensor tensor = this.tf.math.pow(this.getOperand(), this.toConstant(Float.valueOf(0.33333334f), this.getDataType())).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray floor() {
        try (Tensor tensor = this.tf.math.floor(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray ceil() {
        try (Tensor tensor = this.tf.math.ceil(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray round() {
        try (Tensor tensor = this.tf.math.round(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray trunc() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray exp() {
        try (Tensor tensor = this.tf.math.exp(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray log() {
        try (Tensor tensor = this.tf.math.log(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray log10() {
        try (Tensor tensor = this.tf.math.div((Operand)this.tf.math.log(this.getOperand()), (Operand)this.tf.math.log(this.toConstant(10, this.getDataType()))).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray log2() {
        try (Tensor tensor = this.tf.math.div((Operand)this.tf.math.log(this.getOperand()), (Operand)this.tf.math.log(this.toConstant(2, this.getDataType()))).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray sin() {
        try (Tensor tensor = this.tf.math.sin(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray cos() {
        try (Tensor tensor = this.tf.math.cos(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray tan() {
        try (Tensor tensor = this.tf.math.tan(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray asin() {
        try (Tensor tensor = this.tf.math.asin(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray acos() {
        try (Tensor tensor = this.tf.math.acos(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray atan() {
        try (Tensor tensor = this.tf.math.atan(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray sinh() {
        try (Tensor tensor = this.tf.math.sinh(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray cosh() {
        try (Tensor tensor = this.tf.math.cosh(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray tanh() {
        try (Tensor tensor = this.tf.math.tanh(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray asinh() {
        try (Tensor tensor = this.tf.math.asinh(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray acosh() {
        try (Tensor tensor = this.tf.math.acosh(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray atanh() {
        try (Tensor tensor = this.tf.math.atanh(this.getOperand()).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray toDegrees() {
        return this.mul(180).div((Number)Math.PI);
    }

    public NDArray toRadians() {
        return this.mul(Math.PI).div((Number)180);
    }

    public NDArray max() {
        try (Tensor tensor = this.tf.max(this.getOperand(), ((TfNDArray)this.manager.arange(0, this.getRank(), 1)).getOperand(), new Max.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray max(int[] axes, boolean keepDims) {
        try (Tensor tensor = this.tf.max(this.getOperand(), (Operand)this.tf.constant(axes), new Max.Options[]{Max.keepDims((Boolean)keepDims)}).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray min() {
        try (Tensor tensor = this.tf.min(this.getOperand(), ((TfNDArray)this.manager.arange(0, this.getRank(), 1)).getOperand(), new Min.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray min(int[] axes, boolean keepDims) {
        try (Tensor tensor = this.tf.min(this.getOperand(), (Operand)this.tf.constant(axes), new Min.Options[]{Min.keepDims((Boolean)keepDims)}).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray sum() {
        Cast op = this.getDataType() == DataType.BOOLEAN ? this.tf.dtypes.cast(this.getOperand(), TInt64.DTYPE, new Cast.Options[0]) : this.getOperand();
        try (Tensor tensor = this.tf.sum((Operand)op, (Operand)this.tf.range((Operand)this.tf.constant(0L), (Operand)this.tf.constant((long)this.getRank()), (Operand)this.tf.constant(1L)), new Sum.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray sum(int[] axes, boolean keepDims) {
        try (Tensor tensor = this.tf.sum(this.getOperand(), ((TfNDArray)this.manager.create(axes)).getOperand(), new Sum.Options[]{Sum.keepDims((Boolean)keepDims)}).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray prod() {
        try (Tensor tensor = this.tf.prod(this.getOperand(), (Operand)this.tf.range((Operand)this.tf.constant(0L), (Operand)this.tf.constant((long)this.getRank()), (Operand)this.tf.constant(1L)), new Prod.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray prod(int[] axes, boolean keepDims) {
        try (Tensor tensor = this.tf.prod(this.getOperand(), (Operand)this.tf.constant(axes), new Prod.Options[]{Prod.keepDims((Boolean)keepDims)}).asOutput().asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    /*
     * Exception decompiling
     */
    public NDArray mean() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray mean(int[] axes, boolean keepDims) {
        try (Tensor tensor = this.tf.math.mean(this.getOperand(), (Operand)this.tf.constant(axes), new Mean.Options[]{Mean.keepDims((Boolean)keepDims)}).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray rotate90(int times, int[] axes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray trace(int offset, int axis1, int axis2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList split(long[] indices, int axis) {
        if (indices.length > 1000) {
            NDList splitted;
            long[] partialIndices;
            int start;
            NDList result = new NDList();
            long totalSize = this.getShape().get(axis);
            for (start = 0; start < indices.length - 1000 + 2; start += 998) {
                partialIndices = new long[1000];
                System.arraycopy(indices, start, partialIndices, 0, 999);
                partialIndices[999] = totalSize;
                splitted = this.splitHelper(partialIndices, axis);
                splitted.remove(splitted.get(splitted.size() - 1));
                if (start > 0) {
                    splitted.remove(splitted.get(0));
                }
                result.addAll(splitted);
            }
            partialIndices = new long[indices.length - start];
            System.arraycopy(indices, start, partialIndices, 0, partialIndices.length);
            splitted = this.splitHelper(partialIndices, axis);
            splitted.remove(splitted.get(0));
            result.addAll(splitted);
            return result;
        }
        return this.splitHelper(indices, axis);
    }

    private NDList splitHelper(long[] indices, int axis) {
        long totalSize;
        if (indices.length == 0) {
            return new NDList(new NDArray[]{this});
        }
        NDList result = new NDList();
        ArrayList<Long> sizes = new ArrayList<Long>();
        int lastIndex = indices.length - 1;
        long dimSize = this.getShape().get(axis);
        if (indices[0] > 0L) {
            sizes.add(indices[0]);
        }
        for (int i = 1; i < indices.length; ++i) {
            sizes.add(indices[i] - indices[i - 1]);
        }
        if (indices[lastIndex] < dimSize) {
            sizes.add(dimSize - indices[lastIndex]);
        }
        if ((totalSize = sizes.stream().mapToLong(Long::longValue).sum()) != this.getShape().get(axis)) {
            throw new IllegalArgumentException("split sizes :" + totalSize + " must sum to dimension on axis " + axis + ": " + this.getShape().get(axis));
        }
        this.tf.splitV(this.getOperand(), (Operand)this.tf.constant(sizes.stream().mapToInt(Long::intValue).toArray()), (Operand)this.tf.constant(axis), Long.valueOf(sizes.size())).forEach(output -> {
            try (Tensor tensor = output.asTensor();){
                result.add((Object)new TfNDArray((NDManager)this.manager, tensor));
            }
        });
        return result;
    }

    public NDArray flatten() {
        return this.reshape(new ai.djl.ndarray.types.Shape(new long[]{-1L}));
    }

    public NDArray reshape(ai.djl.ndarray.types.Shape shape) {
        try (Tensor tensor = this.tf.reshape(this.getOperand(), (Operand)this.tf.constant(shape.getShape())).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray expandDims(int axis) {
        try (Tensor tensor = this.tf.expandDims(this.getOperand(), (Operand)this.tf.constant(axis)).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray squeeze(int[] axes) {
        if (this.isScalar()) {
            axes = new int[]{};
        }
        try (Tensor tensor = this.tf.squeeze(this.getOperand(), new Squeeze.Options[]{Squeeze.axis(Arrays.stream(axes).mapToLong(i -> i).boxed().collect(Collectors.toList()))}).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray logicalAnd(NDArray n) {
        try (Tensor tensor = this.tf.math.logicalAnd((Operand)this.tf.dtypes.cast(this.getOperand(), TBool.DTYPE, new Cast.Options[0]), (Operand)this.tf.dtypes.cast(((TfNDArray)n).getOperand(), TBool.DTYPE, new Cast.Options[0])).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray logicalOr(NDArray n) {
        try (Tensor tensor = this.tf.math.logicalOr((Operand)this.tf.dtypes.cast(this.getOperand(), TBool.DTYPE, new Cast.Options[0]), (Operand)this.tf.dtypes.cast(((TfNDArray)n).getOperand(), TBool.DTYPE, new Cast.Options[0])).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray logicalXor(NDArray n) {
        return this.logicalOr(n).logicalAnd(this.logicalAnd(n).logicalNot());
    }

    public NDArray logicalNot() {
        try (Tensor tensor = this.tf.math.logicalNot((Operand)this.tf.dtypes.cast(this.getOperand(), TBool.DTYPE, new Cast.Options[0])).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray argSort(int axis, boolean ascending) {
        return this.sortHelper(axis, ascending, true);
    }

    public NDArray sort(int axis) {
        return this.sortHelper(axis, true, false);
    }

    public NDArray sort() {
        return this.sortHelper(-1, true, false);
    }

    private NDArray sortHelper(int axis, boolean ascending, boolean returnIndices) {
        int k;
        Transpose input;
        NDArray transposition;
        if (this.isScalar()) {
            return this;
        }
        int rank = this.getRank();
        if (axis == -1 || axis + 1 == this.getShape().dimension()) {
            transposition = null;
            input = this.getOperand();
            long[] arrayShape = this.getShape().getShape();
            k = (int)arrayShape[arrayShape.length - 1];
        } else {
            k = (int)this.getShape().getShape()[axis];
            transposition = NDArrays.concat((NDList)new NDList(new NDArray[]{this.manager.arange(0.0f, axis, 1.0f, DataType.INT32, this.getDevice()), this.manager.create(new int[]{rank - 1}), this.manager.arange(axis + 1, rank - 1, 1.0f, DataType.INT32, this.getDevice()), this.manager.create(new int[]{axis})}));
            input = this.tf.linalg.transpose(this.getOperand(), ((TfNDArray)transposition).getOperand());
        }
        TopK topK = ascending ? this.tf.nn.topK((Operand)this.tf.math.neg(input), (Operand)this.tf.constant(k), new TopK.Options[0]) : this.tf.nn.topK(input, (Operand)this.tf.constant(k), new TopK.Options[0]);
        Object result = returnIndices ? this.tf.dtypes.cast((Operand)topK.indices(), TInt64.DTYPE, new Cast.Options[0]) : topK.values();
        if (transposition != null) {
            result = this.tf.linalg.transpose((Operand)result, ((TfNDArray)transposition).getOperand());
            transposition.close();
        }
        if (ascending && !returnIndices) {
            result = this.tf.math.neg((Operand)result);
        }
        try (Tensor tensor = result.asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray softmax(int axis) {
        try (Tensor tensor = this.softmaxHelper(axis, false).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray logSoftmax(int axis) {
        try (Tensor tensor = this.softmaxHelper(axis, true).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    private Operand softmaxHelper(int axis, boolean logSoftmax) {
        long dim = this.getShape().dimension();
        if (dim == 0L) {
            return this.getOperand();
        }
        if (axis == -1 || (long)axis == dim - 1L) {
            return logSoftmax ? this.tf.nn.logSoftmax(this.getOperand()) : this.tf.nn.softmax(this.getOperand());
        }
        if ((long)axis < -dim || (long)axis >= dim) {
            throw new IllegalArgumentException("Invalid axes value: " + axis + ", must be in range [" + -dim + ", " + dim + ") where " + dim + " is the number of dimensions in the input.");
        }
        ArrayList<Object> concatList = new ArrayList<Object>();
        concatList.add(this.tf.range((Operand)this.tf.constant(0L), (Operand)this.tf.constant((long)axis % dim), (Operand)this.tf.constant(1L)));
        concatList.add(this.tf.expandDims((Operand)this.tf.constant(dim - 1L), (Operand)this.tf.constant(0)));
        concatList.add(this.tf.range((Operand)this.tf.constant((long)axis + 1L), (Operand)this.tf.constant(dim - 1L), (Operand)this.tf.constant(1L)));
        concatList.add(this.tf.expandDims((Operand)this.tf.constant((long)axis), (Operand)this.tf.constant(0)));
        Transpose transposed = this.tf.linalg.transpose(this.getOperand(), (Operand)this.tf.concat(concatList, (Operand)this.tf.constant(0)));
        LogSoftmax output = logSoftmax ? this.tf.nn.logSoftmax((Operand)transposed) : this.tf.nn.softmax((Operand)transposed);
        return this.tf.linalg.transpose((Operand)output, (Operand)this.tf.concat(concatList, (Operand)this.tf.constant(0)));
    }

    public NDArray cumSum(int axis) {
        if (this.isScalar()) {
            return this.expandDims(0);
        }
        if (Arrays.stream(this.getShape().getShape()).anyMatch(dim -> dim == 0L)) {
            return this.manager.create(new ai.djl.ndarray.types.Shape(new long[]{0L}));
        }
        try (Tensor tensor = this.tf.math.cumsum(this.getOperand(), (Operand)this.tf.constant(axis), new Cumsum.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray cumSum() {
        return this.cumSum(0);
    }

    public NDArray isInfinite() {
        try (Tensor tensor = this.tf.dtypes.cast((Operand)this.tf.math.isInf(this.getOperand()), TBool.DTYPE, new Cast.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray isNaN() {
        try (Tensor tensor = this.tf.dtypes.cast((Operand)this.tf.math.isNan(this.getOperand()), TBool.DTYPE, new Cast.Options[0]).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray tile(long repeats) {
        long[] multiples = new long[this.getShape().dimension()];
        Arrays.fill(multiples, repeats);
        return this.tile(multiples);
    }

    public NDArray tile(int axis, long repeats) {
        long[] multiples = new long[this.getShape().dimension()];
        Arrays.fill(multiples, 1L);
        multiples[axis] = repeats;
        return this.tile(multiples);
    }

    public NDArray tile(long[] repeats) {
        try (Tensor tensor = this.tf.tile(this.getOperand(), (Operand)this.tf.constant(repeats)).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray tile(ai.djl.ndarray.types.Shape desiredShape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray repeat(long repeats) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray repeat(int axis, long repeats) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray repeat(long[] repeats) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray repeat(ai.djl.ndarray.types.Shape desiredShape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray dot(NDArray other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray matMul(NDArray other) {
        if (this.isScalar() || other.isScalar()) {
            throw new IllegalArgumentException("scalar is not allowed for matMul()");
        }
        if (this.getShape().dimension() > 2 || other.getShape().dimension() > 2) {
            try (Tensor tensor = this.tf.train.batchMatMul(this.getOperand(), ((TfNDArray)other).getOperand(), new BatchMatMul.Options[0]).asTensor();){
                TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
                return tfNDArray;
            }
        }
        BroadcastTo lhs = this.getOperand();
        BroadcastTo rhs = ((TfNDArray)other).getOperand();
        boolean broadcast = false;
        if (this.getShape().dimension() == 1) {
            lhs = this.tf.broadcastTo(this.getOperand(), (Operand)this.tf.constant(new long[]{1L, this.getShape().get(0)}));
            broadcast = true;
        }
        if (other.getShape().dimension() == 1) {
            rhs = this.tf.broadcastTo(((TfNDArray)other).getOperand(), (Operand)this.tf.constant(new long[]{1L, this.getShape().get(0)}));
            broadcast = true;
        }
        try (Tensor tensor = this.tf.linalg.matMul(lhs, rhs, new MatMul.Options[0]).asTensor();){
            TfNDArray result = new TfNDArray((NDManager)this.manager, tensor);
            if (broadcast) {
                NDArray nDArray = result.squeeze();
                return nDArray;
            }
            TfNDArray tfNDArray = result;
            return tfNDArray;
        }
    }

    public NDArray clip(Number min, Number max) {
        try (Tensor tensor = this.tf.clipByValue(this.getOperand(), this.toConstant(min, this.getDataType()), this.toConstant(max, this.getDataType())).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray flip(int ... axes) {
        try (Tensor tensor = this.tf.reverse(this.getOperand(), (Operand)this.tf.constant(axes)).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray transpose() {
        int dim = this.getShape().dimension();
        int[] reversedShape = IntStream.range(0, dim).map(i -> dim - i - 1).toArray();
        return this.transpose(reversedShape);
    }

    public NDArray transpose(int ... dimensions) {
        if (Arrays.stream(dimensions).anyMatch(d -> d < 0)) {
            throw new UnsupportedOperationException("Passing -1 for broadcasting the dimension is not currently supported");
        }
        if (!Arrays.equals(Arrays.stream(dimensions).sorted().toArray(), IntStream.range(0, this.getShape().dimension()).toArray())) {
            throw new IllegalArgumentException("You must include each of the dimensions from 0 until " + this.getShape().dimension());
        }
        try (Tensor tensor = this.tf.linalg.transpose(this.getOperand(), (Operand)this.tf.constant(dimensions)).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray broadcast(ai.djl.ndarray.types.Shape shape) {
        try (Tensor tensor = this.tf.broadcastTo(this.getOperand(), (Operand)this.tf.constant(shape.getShape())).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray argMax() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("attempt to get argMax of an empty NDArray");
        }
        return this.flatten().argMax(0);
    }

    public NDArray argMax(int axis) {
        if (this.isScalar()) {
            return this.manager.create(0L);
        }
        try (Tensor tensor = this.tf.math.argMax(this.getOperand(), (Operand)this.tf.constant(axis)).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray argMin() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("attempt to get argMin of an empty NDArray");
        }
        return this.flatten().argMin(0);
    }

    public NDArray argMin(int axis) {
        if (this.isScalar()) {
            return this.manager.create(0L);
        }
        try (Tensor tensor = this.tf.math.argMin(this.getOperand(), (Operand)this.tf.constant(axis)).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this.manager, tensor);
            return tfNDArray;
        }
    }

    public NDArray percentile(Number percentile) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray percentile(Number percentile, int[] dimension) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray median() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray median(int[] axes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray toDense() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray nonzero() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArrayEx getNDArrayInternal() {
        return this.tfNDArrayEx;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TfNDArray) {
            return this.contentEquals((TfNDArray)obj);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        if (this.operand == null) {
            return "This array is already closed";
        }
        return this.toDebugString(100, 10, 10, 20);
    }

    public void close() {
        this.tf = null;
        this.operand = null;
        this.tfNDArrayEx = null;
    }

    <T extends TType> Operand<T> getOperand() {
        return this.operand;
    }

    private String getTfDevice() {
        if (this.getDevice().getDeviceType().equals("cpu")) {
            return "/device:CPU:0";
        }
        if (this.getDevice().getDeviceType().equals("gpu")) {
            return "/device:GPU:" + this.getDevice().getDeviceId();
        }
        throw new EngineException("Unknown device type to TensorFlow Engine: " + this.getDevice().toString());
    }

    public Tensor<?> getTensor() {
        return this.operand.asTensor();
    }

    void setOperand(Operand<?> operand) {
        this.operand = operand;
    }

    int getRank() {
        try (Tensor tensor = this.tf.rank(this.getOperand()).asOutput().tensor();){
            int n = tensor.rawData().asInts().getInt(0L);
            return n;
        }
    }

    private <T extends TType> Constant<T> toConstant(Number n, DataType jType) {
        return TfNDArray.getConstant(n, jType, this.tf);
    }

    public static Shape toTfShape(ai.djl.ndarray.types.Shape shape) {
        return Shape.of((long[])shape.getShape());
    }

    public static ByteDataBuffer toDataBuffer(FloatBuffer buffer) {
        ByteBuffer bb = ByteBuffer.allocate(buffer.remaining() * 4);
        bb.asFloatBuffer().put(buffer);
        return DataBuffers.of((ByteBuffer)bb);
    }

    static <T extends TType> Constant<T> getConstant(Number n, DataType jType, Ops tf) {
        switch (jType) {
            case INT8: {
                return tf.constant(n.byteValue());
            }
            case INT32: {
                return tf.constant(n.intValue());
            }
            case INT64: {
                return tf.constant(n.longValue());
            }
            case FLOAT16: {
                return tf.constant((int)n.shortValue());
            }
            case FLOAT32: {
                return tf.constant(n.floatValue());
            }
            case FLOAT64: {
                return tf.constant(n.doubleValue());
            }
        }
        throw new EngineException("unsupported type");
    }
}

