/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.DataType;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.types.TInt64Impl;
import org.tensorflow.types.family.TNumber;

public interface TInt64
extends LongNdArray,
TNumber {
    public static final String NAME = "INT64";
    public static final DataType<TInt64> DTYPE = DataType.create("INT64", 9, 8, TInt64Impl::mapTensor);

    public static Tensor<TInt64> scalarOf(long value) {
        return Tensor.of(DTYPE, Shape.scalar(), data -> data.setLong(value, new long[0]));
    }

    public static Tensor<TInt64> vectorOf(long ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(DTYPE, Shape.of(values.length), data -> StdArrays.copyTo(values, (LongNdArray)data));
    }

    public static Tensor<TInt64> tensorOf(NdArray<Long> src) {
        return Tensor.of(DTYPE, src.shape(), src::copyTo);
    }

    public static Tensor<TInt64> tensorOf(Shape shape) {
        return Tensor.of(DTYPE, shape);
    }

    public static Tensor<TInt64> tensorOf(Shape shape, LongDataBuffer data) {
        return Tensor.of(DTYPE, shape, d -> d.write(data));
    }

    public static Tensor<TInt64> tensorOf(Shape shape, Consumer<TInt64> dataInit) {
        return Tensor.of(DTYPE, shape, dataInit);
    }
}

