/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class InfeedEnqueue
extends RawOp {
    public static final String OP_NAME = "InfeedEnqueue";

    public static <T extends TType> InfeedEnqueue create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.shape != null) {
                    opBuilder.setAttr("shape", opts.shape);
                }
                if (opts.layout != null) {
                    long[] layoutArray = new long[opts.layout.size()];
                    for (int i = 0; i < layoutArray.length; ++i) {
                        layoutArray[i] = (Long)opts.layout.get(i);
                    }
                    opBuilder.setAttr("layout", layoutArray);
                }
                if (opts.deviceOrdinal == null) continue;
                opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
            }
        }
        return new InfeedEnqueue(opBuilder.build());
    }

    public static Options shape(Shape shape) {
        return new Options().shape(shape);
    }

    public static Options layout(List<Long> layout) {
        return new Options().layout(layout);
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    private InfeedEnqueue(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Shape shape;
        private List<Long> layout;
        private Long deviceOrdinal;

        public Options shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        public Options layout(List<Long> layout) {
            this.layout = layout;
            return this;
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }

        private Options() {
        }
    }
}

