/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class RaggedGather<T extends TNumber, U extends TType>
extends RawOp {
    public static final String OP_NAME = "RaggedGather";
    private List<Output<T>> outputNestedSplits;
    private Output<U> outputDenseValues;

    public static <T extends TNumber, U extends TType, V extends TNumber> RaggedGather<T, U> create(Scope scope, Iterable<Operand<T>> paramsNestedSplits, Operand<U> paramsDenseValues, Operand<V> indices, Long OUTPUTRAGGEDRANK) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInputList(Operands.asOutputs(paramsNestedSplits));
        opBuilder.addInput(paramsDenseValues.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("OUTPUT_RAGGED_RANK", OUTPUTRAGGEDRANK);
        return new RaggedGather<T, U>(opBuilder.build());
    }

    public List<Output<T>> outputNestedSplits() {
        return this.outputNestedSplits;
    }

    public Output<U> outputDenseValues() {
        return this.outputDenseValues;
    }

    private RaggedGather(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputNestedSplitsLength = operation.outputListLength("output_nested_splits");
        this.outputNestedSplits = Arrays.asList(operation.outputList(outputIdx, outputNestedSplitsLength));
        outputIdx += outputNestedSplitsLength;
        this.outputDenseValues = operation.output(outputIdx++);
    }
}

