/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class CudnnRNNBackprop<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "CudnnRNNBackpropV3";
    private Output<T> inputBackprop;
    private Output<T> inputHBackprop;
    private Output<T> inputCBackprop;
    private Output<T> paramsBackprop;

    public static <T extends TNumber> CudnnRNNBackprop<T> create(Scope scope, Operand<T> input, Operand<T> inputH, Operand<T> inputC, Operand<T> params, Operand<TInt32> sequenceLengths, Operand<T> output, Operand<T> outputH, Operand<T> outputC, Operand<T> outputBackprop, Operand<T> outputHBackprop, Operand<T> outputCBackprop, Operand<T> reserveSpace, Operand<?> hostReserved, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("CudnnRNNBackprop"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputH.asOutput());
        opBuilder.addInput(inputC.asOutput());
        opBuilder.addInput(params.asOutput());
        opBuilder.addInput(sequenceLengths.asOutput());
        opBuilder.addInput(output.asOutput());
        opBuilder.addInput(outputH.asOutput());
        opBuilder.addInput(outputC.asOutput());
        opBuilder.addInput(outputBackprop.asOutput());
        opBuilder.addInput(outputHBackprop.asOutput());
        opBuilder.addInput(outputCBackprop.asOutput());
        opBuilder.addInput(reserveSpace.asOutput());
        opBuilder.addInput(hostReserved.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.rnnMode != null) {
                    opBuilder.setAttr("rnn_mode", opts.rnnMode);
                }
                if (opts.inputMode != null) {
                    opBuilder.setAttr("input_mode", opts.inputMode);
                }
                if (opts.direction != null) {
                    opBuilder.setAttr("direction", opts.direction);
                }
                if (opts.dropout != null) {
                    opBuilder.setAttr("dropout", opts.dropout.floatValue());
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.numProj != null) {
                    opBuilder.setAttr("num_proj", opts.numProj);
                }
                if (opts.timeMajor == null) continue;
                opBuilder.setAttr("time_major", opts.timeMajor);
            }
        }
        return new CudnnRNNBackprop<T>(opBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options numProj(Long numProj) {
        return new Options().numProj(numProj);
    }

    public static Options timeMajor(Boolean timeMajor) {
        return new Options().timeMajor(timeMajor);
    }

    public Output<T> inputBackprop() {
        return this.inputBackprop;
    }

    public Output<T> inputHBackprop() {
        return this.inputHBackprop;
    }

    public Output<T> inputCBackprop() {
        return this.inputCBackprop;
    }

    public Output<T> paramsBackprop() {
        return this.paramsBackprop;
    }

    private CudnnRNNBackprop(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.inputBackprop = operation.output(outputIdx++);
        this.inputHBackprop = operation.output(outputIdx++);
        this.inputCBackprop = operation.output(outputIdx++);
        this.paramsBackprop = operation.output(outputIdx++);
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;
        private Long numProj;
        private Boolean timeMajor;

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options numProj(Long numProj) {
            this.numProj = numProj;
            return this;
        }

        public Options timeMajor(Boolean timeMajor) {
            this.timeMajor = timeMajor;
            return this;
        }

        private Options() {
        }
    }
}

