/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

public final class TensorArray
extends RawOp {
    public static final String OP_NAME = "TensorArrayV3";
    private Output<?> handle;
    private Output<TFloat32> flow;

    public static <T extends TType> TensorArray create(Scope scope, Operand<TInt32> size, DataType<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("TensorArray"));
        opBuilder.addInput(size.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", dtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShape != null) {
                    opBuilder.setAttr("element_shape", opts.elementShape);
                }
                if (opts.dynamicSize != null) {
                    opBuilder.setAttr("dynamic_size", opts.dynamicSize);
                }
                if (opts.clearAfterRead != null) {
                    opBuilder.setAttr("clear_after_read", opts.clearAfterRead);
                }
                if (opts.identicalElementShapes != null) {
                    opBuilder.setAttr("identical_element_shapes", opts.identicalElementShapes);
                }
                if (opts.tensorArrayName == null) continue;
                opBuilder.setAttr("tensor_array_name", opts.tensorArrayName);
            }
        }
        return new TensorArray(opBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public static Options dynamicSize(Boolean dynamicSize) {
        return new Options().dynamicSize(dynamicSize);
    }

    public static Options clearAfterRead(Boolean clearAfterRead) {
        return new Options().clearAfterRead(clearAfterRead);
    }

    public static Options identicalElementShapes(Boolean identicalElementShapes) {
        return new Options().identicalElementShapes(identicalElementShapes);
    }

    public static Options tensorArrayName(String tensorArrayName) {
        return new Options().tensorArrayName(tensorArrayName);
    }

    public Output<?> handle() {
        return this.handle;
    }

    public Output<TFloat32> flow() {
        return this.flow;
    }

    private TensorArray(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
        this.flow = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape elementShape;
        private Boolean dynamicSize;
        private Boolean clearAfterRead;
        private Boolean identicalElementShapes;
        private String tensorArrayName;

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }

        public Options dynamicSize(Boolean dynamicSize) {
            this.dynamicSize = dynamicSize;
            return this;
        }

        public Options clearAfterRead(Boolean clearAfterRead) {
            this.clearAfterRead = clearAfterRead;
            return this;
        }

        public Options identicalElementShapes(Boolean identicalElementShapes) {
            this.identicalElementShapes = identicalElementShapes;
            return this;
        }

        public Options tensorArrayName(String tensorArrayName) {
            this.tensorArrayName = tensorArrayName;
            return this;
        }

        private Options() {
        }
    }
}

