/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.Tensor;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.types.TBfloat16;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TFloat16;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TFloat64;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;
import org.tensorflow.types.family.TType;

public final class DataType<T extends TType> {
    private final int nativeCode;
    private final int byteSize;
    private final String name;
    private final TensorMapper<T> tensorMapper;

    public static <T extends TType> DataType<T> create(String name, int value, int byteSize, TensorMapper<T> tensorMapper) {
        return new DataType<T>(name, value, byteSize, tensorMapper);
    }

    public static DataType<? extends TType> of(String name) {
        switch (name) {
            case "BFLOAT16": {
                return TBfloat16.DTYPE;
            }
            case "FLOAT16": {
                return TFloat16.DTYPE;
            }
            case "FLOAT": {
                return TFloat32.DTYPE;
            }
            case "DOUBLE": {
                return TFloat64.DTYPE;
            }
            case "UINT8": {
                return TUint8.DTYPE;
            }
            case "INT32": {
                return TInt32.DTYPE;
            }
            case "INT64": {
                return TInt64.DTYPE;
            }
            case "BOOL": {
                return TBool.DTYPE;
            }
            case "STRING": {
                return TString.DTYPE;
            }
        }
        throw new IllegalArgumentException(String.format("%s is an unknown DataType", name));
    }

    public boolean isFloating() {
        switch (this.name()) {
            case "BFLOAT16": 
            case "FLOAT16": 
            case "FLOAT": 
            case "DOUBLE": {
                return true;
            }
        }
        return false;
    }

    public boolean isInteger() {
        switch (this.name()) {
            case "INT32": 
            case "INT64": 
            case "UINT8": {
                return true;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        return this.isFloating() || this.isInteger();
    }

    public boolean isBoolean() {
        return this.name().equals("BOOL");
    }

    public boolean isString() {
        return this.name().equals("STRING");
    }

    public int byteSize() {
        return this.byteSize;
    }

    public boolean isVariableLength() {
        return this.byteSize == -1;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name + " (" + this.nativeCode + ")";
    }

    int nativeCode() {
        return this.nativeCode;
    }

    T map(Tensor<T> tensor) {
        return (T)((TType)this.tensorMapper.apply(tensor.nativeHandle(), tensor.shape()));
    }

    private DataType(String name, int nativeCode, int byteSize, TensorMapper<T> tensorMapper) {
        this.name = name;
        this.nativeCode = nativeCode;
        this.byteSize = byteSize;
        this.tensorMapper = tensorMapper;
    }

    @FunctionalInterface
    public static interface TensorMapper<T> {
        public T apply(TF_Tensor var1, Shape var2);
    }
}

