/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

public final class QuantizedConcat<T extends TType>
extends RawOp {
    private Output<T> output;
    private Output<TFloat32> outputMin;
    private Output<TFloat32> outputMax;

    public static <T extends TType> QuantizedConcat<T> create(Scope scope, Operand<TInt32> concatDim, Iterable<Operand<T>> values, Iterable<Operand<TFloat32>> inputMins, Iterable<Operand<TFloat32>> inputMaxes) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedConcat", scope.makeOpName("QuantizedConcat"));
        opBuilder.addInput(concatDim.asOutput());
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(inputMins));
        opBuilder.addInputList(Operands.asOutputs(inputMaxes));
        opBuilder = scope.applyControlDependencies(opBuilder);
        return new QuantizedConcat<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<TFloat32> outputMin() {
        return this.outputMin;
    }

    public Output<TFloat32> outputMax() {
        return this.outputMax;
    }

    private QuantizedConcat(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }
}

