/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

public final class BoostedTreesTrainingPredict
extends RawOp {
    private Output<TFloat32> partialLogits;
    private Output<TInt32> treeIds;
    private Output<TInt32> nodeIds;

    public static BoostedTreesTrainingPredict create(Scope scope, Operand<?> treeEnsembleHandle, Operand<TInt32> cachedTreeIds, Operand<TInt32> cachedNodeIds, Iterable<Operand<TInt32>> bucketizedFeatures, Long logitsDimension) {
        OperationBuilder opBuilder = scope.env().opBuilder("BoostedTreesTrainingPredict", scope.makeOpName("BoostedTreesTrainingPredict"));
        opBuilder.addInput(treeEnsembleHandle.asOutput());
        opBuilder.addInput(cachedTreeIds.asOutput());
        opBuilder.addInput(cachedNodeIds.asOutput());
        opBuilder.addInputList(Operands.asOutputs(bucketizedFeatures));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("logits_dimension", logitsDimension);
        return new BoostedTreesTrainingPredict(opBuilder.build());
    }

    public Output<TFloat32> partialLogits() {
        return this.partialLogits;
    }

    public Output<TInt32> treeIds() {
        return this.treeIds;
    }

    public Output<TInt32> nodeIds() {
        return this.nodeIds;
    }

    private BoostedTreesTrainingPredict(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.partialLogits = operation.output(outputIdx++);
        this.treeIds = operation.output(outputIdx++);
        this.nodeIds = operation.output(outputIdx++);
    }
}

