/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.sequence;

import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.tools.ndarray.impl.sequence.IndexedPositionIterator;
import org.tensorflow.tools.ndarray.impl.sequence.SequentialPositionIterator;

class IndexedSequentialPositionIterator
extends SequentialPositionIterator
implements IndexedPositionIterator {
    private final long[] shape;
    private final long[] coords;

    @Override
    public void forEachIndexed(IndexedPositionIterator.CoordsLongConsumer consumer) {
        while (this.hasNext()) {
            consumer.consume(this.coords, this.nextLong());
            this.incrementCoords();
        }
    }

    private void incrementCoords() {
        for (int i = this.coords.length - 1; i >= 0; --i) {
            if (this.coords[i] < this.shape[i] - 1L) {
                int n = i;
                this.coords[n] = this.coords[n] + 1L;
                return;
            }
            this.coords[i] = 0L;
        }
    }

    IndexedSequentialPositionIterator(DimensionalSpace dimensions, int dimensionIdx) {
        super(dimensions, dimensionIdx);
        this.shape = dimensions.shape().asArray();
        this.coords = new long[dimensionIdx + 1];
    }
}

