/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

public final class TensorArrayGather<T extends TType>
extends RawOp
implements Operand<T> {
    private Output<T> value;

    public static <T extends TType> TensorArrayGather<T> create(Scope scope, Operand<?> handle, Operand<TInt32> indices, Operand<TFloat32> flowIn, DataType<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("TensorArrayGatherV3", scope.makeOpName("TensorArrayGather"));
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", dtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShape == null) continue;
                opBuilder.setAttr("element_shape", opts.elementShape);
            }
        }
        return new TensorArrayGather<T>(opBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public Output<T> value() {
        return this.value;
    }

    @Override
    public Output<T> asOutput() {
        return this.value;
    }

    private TensorArrayGather(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape elementShape;

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }

        private Options() {
        }
    }
}

