/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class BarrierTakeMany
extends RawOp {
    private Output<TInt64> indices;
    private Output<TString> keys;
    private List<Output<?>> values;

    public static BarrierTakeMany create(Scope scope, Operand<TString> handle, Operand<TInt32> numElements, List<DataType<?>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("BarrierTakeMany", scope.makeOpName("BarrierTakeMany"));
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(numElements.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] componentTypesArray = new DataType[componentTypes.size()];
        for (int i = 0; i < componentTypesArray.length; ++i) {
            componentTypesArray[i] = componentTypes.get(i);
        }
        opBuilder.setAttr("component_types", componentTypesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.allowSmallBatch != null) {
                    opBuilder.setAttr("allow_small_batch", opts.allowSmallBatch);
                }
                if (opts.waitForIncomplete != null) {
                    opBuilder.setAttr("wait_for_incomplete", opts.waitForIncomplete);
                }
                if (opts.timeoutMs == null) continue;
                opBuilder.setAttr("timeout_ms", opts.timeoutMs);
            }
        }
        return new BarrierTakeMany(opBuilder.build());
    }

    public static Options allowSmallBatch(Boolean allowSmallBatch) {
        return new Options().allowSmallBatch(allowSmallBatch);
    }

    public static Options waitForIncomplete(Boolean waitForIncomplete) {
        return new Options().waitForIncomplete(waitForIncomplete);
    }

    public static Options timeoutMs(Long timeoutMs) {
        return new Options().timeoutMs(timeoutMs);
    }

    public Output<TInt64> indices() {
        return this.indices;
    }

    public Output<TString> keys() {
        return this.keys;
    }

    public List<Output<?>> values() {
        return this.values;
    }

    private BarrierTakeMany(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.keys = operation.output(outputIdx++);
        int valuesLength = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(outputIdx, valuesLength));
        outputIdx += valuesLength;
    }

    public static class Options {
        private Boolean allowSmallBatch;
        private Boolean waitForIncomplete;
        private Long timeoutMs;

        public Options allowSmallBatch(Boolean allowSmallBatch) {
            this.allowSmallBatch = allowSmallBatch;
            return this;
        }

        public Options waitForIncomplete(Boolean waitForIncomplete) {
            this.waitForIncomplete = waitForIncomplete;
            return this;
        }

        public Options timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        private Options() {
        }
    }
}

