/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.DataExperimentalOps;
import org.tensorflow.op.Scope;
import org.tensorflow.op.data.AnonymousIterator;
import org.tensorflow.op.data.BatchDataset;
import org.tensorflow.op.data.CSVDataset;
import org.tensorflow.op.data.ConcatenateDataset;
import org.tensorflow.op.data.DeleteIterator;
import org.tensorflow.op.data.DeserializeIterator;
import org.tensorflow.op.data.Iterator;
import org.tensorflow.op.data.IteratorGetNext;
import org.tensorflow.op.data.IteratorGetNextAsOptional;
import org.tensorflow.op.data.IteratorGetNextSync;
import org.tensorflow.op.data.IteratorToStringHandle;
import org.tensorflow.op.data.MakeIterator;
import org.tensorflow.op.data.OptionalFromValue;
import org.tensorflow.op.data.OptionalGetValue;
import org.tensorflow.op.data.OptionalHasValue;
import org.tensorflow.op.data.OptionalNone;
import org.tensorflow.op.data.RangeDataset;
import org.tensorflow.op.data.RepeatDataset;
import org.tensorflow.op.data.SerializeIterator;
import org.tensorflow.op.data.SkipDataset;
import org.tensorflow.op.data.TakeDataset;
import org.tensorflow.op.data.TensorSliceDataset;
import org.tensorflow.op.data.TextLineDataset;
import org.tensorflow.op.data.TfRecordDataset;
import org.tensorflow.op.data.ZipDataset;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class DataOps {
    public final DataExperimentalOps experimental;
    private final Scope scope;

    DataOps(Scope scope) {
        this.scope = scope;
        this.experimental = new DataExperimentalOps(scope);
    }

    public AnonymousIterator anonymousIterator(List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return AnonymousIterator.create(this.scope, outputTypes, outputShapes);
    }

    public BatchDataset batchDataset(Operand<?> inputDataset, Operand<TInt64> batchSize, Operand<TBool> dropRemainder, List<DataType<?>> outputTypes, List<Shape> outputShapes, BatchDataset.Options ... options) {
        return BatchDataset.create(this.scope, inputDataset, batchSize, dropRemainder, outputTypes, outputShapes, options);
    }

    public CSVDataset cSVDataset(Operand<TString> filenames, Operand<TString> compressionType, Operand<TInt64> bufferSize, Operand<TBool> header, Operand<TString> fieldDelim, Operand<TBool> useQuoteDelim, Operand<TString> naValue, Operand<TInt64> selectCols, Iterable<Operand<?>> recordDefaults, List<Shape> outputShapes) {
        return CSVDataset.create(this.scope, filenames, compressionType, bufferSize, header, fieldDelim, useQuoteDelim, naValue, selectCols, recordDefaults, outputShapes);
    }

    public ConcatenateDataset concatenateDataset(Operand<?> inputDataset, Operand<?> anotherDataset, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return ConcatenateDataset.create(this.scope, inputDataset, anotherDataset, outputTypes, outputShapes);
    }

    public DeleteIterator deleteIterator(Operand<?> handle, Operand<?> deleter) {
        return DeleteIterator.create(this.scope, handle, deleter);
    }

    public DeserializeIterator deserializeIterator(Operand<?> resourceHandle, Operand<?> serialized) {
        return DeserializeIterator.create(this.scope, resourceHandle, serialized);
    }

    public Iterator iterator(String sharedName, String container, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return Iterator.create(this.scope, sharedName, container, outputTypes, outputShapes);
    }

    public IteratorGetNext iteratorGetNext(Operand<?> iterator, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return IteratorGetNext.create(this.scope, iterator, outputTypes, outputShapes);
    }

    public IteratorGetNextAsOptional iteratorGetNextAsOptional(Operand<?> iterator, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return IteratorGetNextAsOptional.create(this.scope, iterator, outputTypes, outputShapes);
    }

    public IteratorGetNextSync iteratorGetNextSync(Operand<?> iterator, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return IteratorGetNextSync.create(this.scope, iterator, outputTypes, outputShapes);
    }

    public IteratorToStringHandle iteratorToStringHandle(Operand<?> resourceHandle) {
        return IteratorToStringHandle.create(this.scope, resourceHandle);
    }

    public MakeIterator makeIterator(Operand<?> dataset, Operand<?> iterator) {
        return MakeIterator.create(this.scope, dataset, iterator);
    }

    public OptionalFromValue optionalFromValue(Iterable<Operand<?>> components) {
        return OptionalFromValue.create(this.scope, components);
    }

    public OptionalGetValue optionalGetValue(Operand<?> optional, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return OptionalGetValue.create(this.scope, optional, outputTypes, outputShapes);
    }

    public OptionalHasValue optionalHasValue(Operand<?> optional) {
        return OptionalHasValue.create(this.scope, optional);
    }

    public OptionalNone optionalNone() {
        return OptionalNone.create(this.scope);
    }

    public RangeDataset rangeDataset(Operand<TInt64> start, Operand<TInt64> stop, Operand<TInt64> step, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return RangeDataset.create(this.scope, start, stop, step, outputTypes, outputShapes);
    }

    public RepeatDataset repeatDataset(Operand<?> inputDataset, Operand<TInt64> count, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return RepeatDataset.create(this.scope, inputDataset, count, outputTypes, outputShapes);
    }

    public SerializeIterator serializeIterator(Operand<?> resourceHandle, SerializeIterator.Options ... options) {
        return SerializeIterator.create(this.scope, resourceHandle, options);
    }

    public SkipDataset skipDataset(Operand<?> inputDataset, Operand<TInt64> count, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return SkipDataset.create(this.scope, inputDataset, count, outputTypes, outputShapes);
    }

    public TakeDataset takeDataset(Operand<?> inputDataset, Operand<TInt64> count, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return TakeDataset.create(this.scope, inputDataset, count, outputTypes, outputShapes);
    }

    public TensorSliceDataset tensorSliceDataset(Iterable<Operand<?>> components, List<Shape> outputShapes) {
        return TensorSliceDataset.create(this.scope, components, outputShapes);
    }

    public TextLineDataset textLineDataset(Operand<TString> filenames, Operand<TString> compressionType, Operand<TInt64> bufferSize) {
        return TextLineDataset.create(this.scope, filenames, compressionType, bufferSize);
    }

    public TfRecordDataset tfRecordDataset(Operand<TString> filenames, Operand<TString> compressionType, Operand<TInt64> bufferSize) {
        return TfRecordDataset.create(this.scope, filenames, compressionType, bufferSize);
    }

    public ZipDataset zipDataset(Iterable<Operand<?>> inputDatasets, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        return ZipDataset.create(this.scope, inputDatasets, outputTypes, outputShapes);
    }
}

