/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.Tensor;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.types.family.TType;

public final class DataType<T extends TType> {
    private final int nativeCode;
    private final int byteSize;
    private final String name;
    private final TensorMapper<T> tensorMapper;

    public static <T extends TType> DataType<T> create(String name, int value, int byteSize, TensorMapper<T> tensorMapper) {
        return new DataType<T>(name, value, byteSize, tensorMapper);
    }

    public int byteSize() {
        return this.byteSize;
    }

    public boolean isVariableLength() {
        return this.byteSize == -1;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name + " (" + this.nativeCode + ")";
    }

    int nativeCode() {
        return this.nativeCode;
    }

    T map(Tensor<T> tensor) {
        return (T)((TType)this.tensorMapper.apply(tensor.nativeHandle(), tensor.shape()));
    }

    private DataType(String name, int nativeCode, int byteSize, TensorMapper<T> tensorMapper) {
        this.name = name;
        this.nativeCode = nativeCode;
        this.byteSize = byteSize;
        this.tensorMapper = tensorMapper;
    }

    @FunctionalInterface
    public static interface TensorMapper<T> {
        public T apply(TF_Tensor var1, Shape var2);
    }
}

