/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class GenerateVocabRemapping
extends RawOp {
    private Output<TInt64> remapping;
    private Output<TInt32> numPresent;

    public static GenerateVocabRemapping create(Scope scope, Operand<TString> newVocabFile, Operand<TString> oldVocabFile, Long newVocabOffset, Long numNewVocab, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("GenerateVocabRemapping", scope.makeOpName("GenerateVocabRemapping"));
        opBuilder.addInput(newVocabFile.asOutput());
        opBuilder.addInput(oldVocabFile.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("new_vocab_offset", newVocabOffset);
        opBuilder.setAttr("num_new_vocab", numNewVocab);
        if (options != null) {
            for (Options opts : options) {
                if (opts.oldVocabSize == null) continue;
                opBuilder.setAttr("old_vocab_size", opts.oldVocabSize);
            }
        }
        return new GenerateVocabRemapping(opBuilder.build());
    }

    public static Options oldVocabSize(Long oldVocabSize) {
        return new Options().oldVocabSize(oldVocabSize);
    }

    public Output<TInt64> remapping() {
        return this.remapping;
    }

    public Output<TInt32> numPresent() {
        return this.numPresent;
    }

    private GenerateVocabRemapping(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.remapping = operation.output(outputIdx++);
        this.numPresent = operation.output(outputIdx++);
    }

    public static class Options {
        private Long oldVocabSize;

        public Options oldVocabSize(Long oldVocabSize) {
            this.oldVocabSize = oldVocabSize;
            return this;
        }

        private Options() {
        }
    }
}

