/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.dense;

import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.FloatDataBuffer;
import org.tensorflow.tools.ndarray.FloatNdArray;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.impl.dense.AbstractDenseNdArray;
import org.tensorflow.tools.ndarray.impl.dense.DataTransfer;
import org.tensorflow.tools.ndarray.impl.dense.Validator;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;

public class FloatDenseNdArray
extends AbstractDenseNdArray<Float, FloatNdArray>
implements FloatNdArray {
    private final FloatDataBuffer buffer;

    public static FloatNdArray create(FloatDataBuffer buffer, Shape shape) {
        Validator.denseShape(buffer, shape);
        return new FloatDenseNdArray(buffer, shape);
    }

    @Override
    public float getFloat(long ... indices) {
        return this.buffer.getFloat(this.positionOf(indices, true));
    }

    @Override
    public FloatNdArray setFloat(float value, long ... indices) {
        this.buffer.setFloat(value, this.positionOf(indices, true));
        return this;
    }

    @Override
    public FloatNdArray copyTo(NdArray<Float> dst) {
        Validator.copyToNdArrayArgs(this, dst);
        if (dst instanceof FloatDenseNdArray) {
            FloatDenseNdArray floatDst = (FloatDenseNdArray)dst;
            DataTransfer.execute(this.buffer, this.dimensions(), floatDst.buffer, floatDst.dimensions(), DataTransfer::ofFloat);
        } else {
            this.slowCopyTo(dst);
        }
        return this;
    }

    @Override
    public FloatNdArray read(FloatDataBuffer dst) {
        Validator.readToBufferArgs(this, dst);
        DataTransfer.execute(this.buffer, this.dimensions(), dst, DataTransfer::ofFloat);
        return this;
    }

    @Override
    public FloatNdArray write(FloatDataBuffer src) {
        Validator.writeFromBufferArgs(this, src);
        DataTransfer.execute(src, this.buffer, this.dimensions(), DataTransfer::ofFloat);
        return this;
    }

    protected FloatDenseNdArray(FloatDataBuffer buffer, Shape shape) {
        this(buffer, DimensionalSpace.create(shape));
    }

    @Override
    FloatDenseNdArray instantiate(DataBuffer<Float> buffer, DimensionalSpace dimensions) {
        return new FloatDenseNdArray((FloatDataBuffer)buffer, dimensions);
    }

    public FloatDataBuffer buffer() {
        return this.buffer;
    }

    private FloatDenseNdArray(FloatDataBuffer buffer, DimensionalSpace dimensions) {
        super(dimensions);
        this.buffer = buffer;
    }
}

