/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.tools.Shape;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class ParseSequenceExample
extends RawOp {
    private List<Output<TInt64>> contextSparseIndices;
    private List<Output<?>> contextSparseValues;
    private List<Output<TInt64>> contextSparseShapes;
    private List<Output<?>> contextDenseValues;
    private List<Output<?>> contextRaggedValues;
    private List<Output<?>> contextRaggedRowSplits;
    private List<Output<TInt64>> featureListSparseIndices;
    private List<Output<?>> featureListSparseValues;
    private List<Output<TInt64>> featureListSparseShapes;
    private List<Output<?>> featureListDenseValues;
    private List<Output<TInt64>> featureListDenseLengths;
    private List<Output<?>> featureListRaggedValues;
    private List<Output<?>> featureListRaggedOuterSplits;
    private List<Output<?>> featureListRaggedInnerSplits;

    public static ParseSequenceExample create(Scope scope, Operand<TString> serialized, Operand<TString> debugName, Operand<TString> contextSparseKeys, Operand<TString> contextDenseKeys, Operand<TString> contextRaggedKeys, Operand<TString> featureListSparseKeys, Operand<TString> featureListDenseKeys, Operand<TString> featureListRaggedKeys, Operand<TBool> featureListDenseMissingAssumedEmpty, Iterable<Operand<?>> contextDenseDefaults, List<DataType<?>> contextSparseTypes, List<DataType<?>> contextRaggedValueTypes, List<DataType<?>> contextRaggedSplitTypes, List<DataType<?>> featureListDenseTypes, List<DataType<?>> featureListSparseTypes, List<DataType<?>> featureListRaggedValueTypes, List<DataType<?>> featureListRaggedSplitTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ParseSequenceExampleV2", scope.makeOpName("ParseSequenceExample"));
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInput(debugName.asOutput());
        opBuilder.addInput(contextSparseKeys.asOutput());
        opBuilder.addInput(contextDenseKeys.asOutput());
        opBuilder.addInput(contextRaggedKeys.asOutput());
        opBuilder.addInput(featureListSparseKeys.asOutput());
        opBuilder.addInput(featureListDenseKeys.asOutput());
        opBuilder.addInput(featureListRaggedKeys.asOutput());
        opBuilder.addInput(featureListDenseMissingAssumedEmpty.asOutput());
        opBuilder.addInputList(Operands.asOutputs(contextDenseDefaults));
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] contextSparseTypesArray = new DataType[contextSparseTypes.size()];
        for (int i = 0; i < contextSparseTypesArray.length; ++i) {
            contextSparseTypesArray[i] = contextSparseTypes.get(i);
        }
        opBuilder.setAttr("context_sparse_types", contextSparseTypesArray);
        DataType[] contextRaggedValueTypesArray = new DataType[contextRaggedValueTypes.size()];
        for (int i = 0; i < contextRaggedValueTypesArray.length; ++i) {
            contextRaggedValueTypesArray[i] = contextRaggedValueTypes.get(i);
        }
        opBuilder.setAttr("context_ragged_value_types", contextRaggedValueTypesArray);
        DataType[] contextRaggedSplitTypesArray = new DataType[contextRaggedSplitTypes.size()];
        for (int i = 0; i < contextRaggedSplitTypesArray.length; ++i) {
            contextRaggedSplitTypesArray[i] = contextRaggedSplitTypes.get(i);
        }
        opBuilder.setAttr("context_ragged_split_types", contextRaggedSplitTypesArray);
        DataType[] featureListDenseTypesArray = new DataType[featureListDenseTypes.size()];
        for (int i = 0; i < featureListDenseTypesArray.length; ++i) {
            featureListDenseTypesArray[i] = featureListDenseTypes.get(i);
        }
        opBuilder.setAttr("feature_list_dense_types", featureListDenseTypesArray);
        DataType[] featureListSparseTypesArray = new DataType[featureListSparseTypes.size()];
        for (int i = 0; i < featureListSparseTypesArray.length; ++i) {
            featureListSparseTypesArray[i] = featureListSparseTypes.get(i);
        }
        opBuilder.setAttr("feature_list_sparse_types", featureListSparseTypesArray);
        DataType[] featureListRaggedValueTypesArray = new DataType[featureListRaggedValueTypes.size()];
        for (int i = 0; i < featureListRaggedValueTypesArray.length; ++i) {
            featureListRaggedValueTypesArray[i] = featureListRaggedValueTypes.get(i);
        }
        opBuilder.setAttr("feature_list_ragged_value_types", featureListRaggedValueTypesArray);
        DataType[] featureListRaggedSplitTypesArray = new DataType[featureListRaggedSplitTypes.size()];
        for (int i = 0; i < featureListRaggedSplitTypesArray.length; ++i) {
            featureListRaggedSplitTypesArray[i] = featureListRaggedSplitTypes.get(i);
        }
        opBuilder.setAttr("feature_list_ragged_split_types", featureListRaggedSplitTypesArray);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.NcontextSparse != null) {
                    opBuilder.setAttr("Ncontext_sparse", opts.NcontextSparse);
                }
                if (opts.contextDenseShapes != null) {
                    Shape[] contextDenseShapesArray = new Shape[opts.contextDenseShapes.size()];
                    for (i = 0; i < contextDenseShapesArray.length; ++i) {
                        contextDenseShapesArray[i] = (Shape)opts.contextDenseShapes.get(i);
                    }
                    opBuilder.setAttr("context_dense_shapes", contextDenseShapesArray);
                }
                if (opts.NfeatureListSparse != null) {
                    opBuilder.setAttr("Nfeature_list_sparse", opts.NfeatureListSparse);
                }
                if (opts.NfeatureListDense != null) {
                    opBuilder.setAttr("Nfeature_list_dense", opts.NfeatureListDense);
                }
                if (opts.featureListDenseShapes == null) continue;
                Shape[] featureListDenseShapesArray = new Shape[opts.featureListDenseShapes.size()];
                for (i = 0; i < featureListDenseShapesArray.length; ++i) {
                    featureListDenseShapesArray[i] = (Shape)opts.featureListDenseShapes.get(i);
                }
                opBuilder.setAttr("feature_list_dense_shapes", featureListDenseShapesArray);
            }
        }
        return new ParseSequenceExample(opBuilder.build());
    }

    public static Options NcontextSparse(Long NcontextSparse) {
        return new Options().NcontextSparse(NcontextSparse);
    }

    public static Options contextDenseShapes(List<Shape> contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options NfeatureListSparse(Long NfeatureListSparse) {
        return new Options().NfeatureListSparse(NfeatureListSparse);
    }

    public static Options NfeatureListDense(Long NfeatureListDense) {
        return new Options().NfeatureListDense(NfeatureListDense);
    }

    public static Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public List<Output<TInt64>> contextSparseIndices() {
        return this.contextSparseIndices;
    }

    public List<Output<?>> contextSparseValues() {
        return this.contextSparseValues;
    }

    public List<Output<TInt64>> contextSparseShapes() {
        return this.contextSparseShapes;
    }

    public List<Output<?>> contextDenseValues() {
        return this.contextDenseValues;
    }

    public List<Output<?>> contextRaggedValues() {
        return this.contextRaggedValues;
    }

    public List<Output<?>> contextRaggedRowSplits() {
        return this.contextRaggedRowSplits;
    }

    public List<Output<TInt64>> featureListSparseIndices() {
        return this.featureListSparseIndices;
    }

    public List<Output<?>> featureListSparseValues() {
        return this.featureListSparseValues;
    }

    public List<Output<TInt64>> featureListSparseShapes() {
        return this.featureListSparseShapes;
    }

    public List<Output<?>> featureListDenseValues() {
        return this.featureListDenseValues;
    }

    public List<Output<TInt64>> featureListDenseLengths() {
        return this.featureListDenseLengths;
    }

    public List<Output<?>> featureListRaggedValues() {
        return this.featureListRaggedValues;
    }

    public List<Output<?>> featureListRaggedOuterSplits() {
        return this.featureListRaggedOuterSplits;
    }

    public List<Output<?>> featureListRaggedInnerSplits() {
        return this.featureListRaggedInnerSplits;
    }

    private ParseSequenceExample(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int contextSparseIndicesLength = operation.outputListLength("context_sparse_indices");
        this.contextSparseIndices = Arrays.asList(operation.outputList(outputIdx, contextSparseIndicesLength));
        int contextSparseValuesLength = operation.outputListLength("context_sparse_values");
        this.contextSparseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseIndicesLength, contextSparseValuesLength));
        int contextSparseShapesLength = operation.outputListLength("context_sparse_shapes");
        this.contextSparseShapes = Arrays.asList(operation.outputList(outputIdx += contextSparseValuesLength, contextSparseShapesLength));
        int contextDenseValuesLength = operation.outputListLength("context_dense_values");
        this.contextDenseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseShapesLength, contextDenseValuesLength));
        int contextRaggedValuesLength = operation.outputListLength("context_ragged_values");
        this.contextRaggedValues = Arrays.asList(operation.outputList(outputIdx += contextDenseValuesLength, contextRaggedValuesLength));
        int contextRaggedRowSplitsLength = operation.outputListLength("context_ragged_row_splits");
        this.contextRaggedRowSplits = Arrays.asList(operation.outputList(outputIdx += contextRaggedValuesLength, contextRaggedRowSplitsLength));
        int featureListSparseIndicesLength = operation.outputListLength("feature_list_sparse_indices");
        this.featureListSparseIndices = Arrays.asList(operation.outputList(outputIdx += contextRaggedRowSplitsLength, featureListSparseIndicesLength));
        int featureListSparseValuesLength = operation.outputListLength("feature_list_sparse_values");
        this.featureListSparseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseIndicesLength, featureListSparseValuesLength));
        int featureListSparseShapesLength = operation.outputListLength("feature_list_sparse_shapes");
        this.featureListSparseShapes = Arrays.asList(operation.outputList(outputIdx += featureListSparseValuesLength, featureListSparseShapesLength));
        int featureListDenseValuesLength = operation.outputListLength("feature_list_dense_values");
        this.featureListDenseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseShapesLength, featureListDenseValuesLength));
        int featureListDenseLengthsLength = operation.outputListLength("feature_list_dense_lengths");
        this.featureListDenseLengths = Arrays.asList(operation.outputList(outputIdx += featureListDenseValuesLength, featureListDenseLengthsLength));
        int featureListRaggedValuesLength = operation.outputListLength("feature_list_ragged_values");
        this.featureListRaggedValues = Arrays.asList(operation.outputList(outputIdx += featureListDenseLengthsLength, featureListRaggedValuesLength));
        int featureListRaggedOuterSplitsLength = operation.outputListLength("feature_list_ragged_outer_splits");
        this.featureListRaggedOuterSplits = Arrays.asList(operation.outputList(outputIdx += featureListRaggedValuesLength, featureListRaggedOuterSplitsLength));
        int featureListRaggedInnerSplitsLength = operation.outputListLength("feature_list_ragged_inner_splits");
        this.featureListRaggedInnerSplits = Arrays.asList(operation.outputList(outputIdx += featureListRaggedOuterSplitsLength, featureListRaggedInnerSplitsLength));
        outputIdx += featureListRaggedInnerSplitsLength;
    }

    public static class Options {
        private Long NcontextSparse;
        private List<Shape> contextDenseShapes;
        private Long NfeatureListSparse;
        private Long NfeatureListDense;
        private List<Shape> featureListDenseShapes;

        public Options NcontextSparse(Long NcontextSparse) {
            this.NcontextSparse = NcontextSparse;
            return this;
        }

        public Options contextDenseShapes(List<Shape> contextDenseShapes) {
            this.contextDenseShapes = contextDenseShapes;
            return this;
        }

        public Options NfeatureListSparse(Long NfeatureListSparse) {
            this.NfeatureListSparse = NfeatureListSparse;
            return this;
        }

        public Options NfeatureListDense(Long NfeatureListDense) {
            this.NfeatureListDense = NfeatureListDense;
            return this;
        }

        public Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
            this.featureListDenseShapes = featureListDenseShapes;
            return this;
        }

        private Options() {
        }
    }
}

