/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.tools.Shape;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class ShardDataset
extends RawOp
implements Operand<TType> {
    private Output<?> handle;

    public static ShardDataset create(Scope scope, Operand<?> inputDataset, Operand<TInt64> numShards, Operand<TInt64> index, List<DataType<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ShardDataset", scope.makeOpName("ShardDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numShards.asOutput());
        opBuilder.addInput(index.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = outputTypes.get(i);
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.requireNonEmpty == null) continue;
                opBuilder.setAttr("require_non_empty", opts.requireNonEmpty);
            }
        }
        return new ShardDataset(opBuilder.build());
    }

    public static Options requireNonEmpty(Boolean requireNonEmpty) {
        return new Options().requireNonEmpty(requireNonEmpty);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private ShardDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean requireNonEmpty;

        public Options requireNonEmpty(Boolean requireNonEmpty) {
            this.requireNonEmpty = requireNonEmpty;
            return this;
        }

        private Options() {
        }
    }
}

