/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;

public final class DatasetToGraph
extends RawOp
implements Operand<TString> {
    private Output<TString> graph;

    public static DatasetToGraph create(Scope scope, Operand<?> inputDataset, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("DatasetToGraphV2", scope.makeOpName("DatasetToGraph"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.externalStatePolicy != null) {
                    opBuilder.setAttr("external_state_policy", opts.externalStatePolicy);
                }
                if (opts.stripDeviceAssignment == null) continue;
                opBuilder.setAttr("strip_device_assignment", opts.stripDeviceAssignment);
            }
        }
        return new DatasetToGraph(opBuilder.build());
    }

    public static Options externalStatePolicy(Long externalStatePolicy) {
        return new Options().externalStatePolicy(externalStatePolicy);
    }

    public static Options stripDeviceAssignment(Boolean stripDeviceAssignment) {
        return new Options().stripDeviceAssignment(stripDeviceAssignment);
    }

    public Output<TString> graph() {
        return this.graph;
    }

    @Override
    public Output<TString> asOutput() {
        return this.graph;
    }

    private DatasetToGraph(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.graph = operation.output(outputIdx++);
    }

    public static class Options {
        private Long externalStatePolicy;
        private Boolean stripDeviceAssignment;

        public Options externalStatePolicy(Long externalStatePolicy) {
            this.externalStatePolicy = externalStatePolicy;
            return this;
        }

        public Options stripDeviceAssignment(Boolean stripDeviceAssignment) {
            this.stripDeviceAssignment = stripDeviceAssignment;
            return this;
        }

        private Options() {
        }
    }
}

