/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="MaxPoolGradGradWithArgmax", inputsClass=Inputs.class)
public final class MaxPoolGradGradWithArgmax<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "MaxPoolGradGradWithArgmax";
    private Output<T> output;

    public MaxPoolGradGradWithArgmax(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> MaxPoolGradGradWithArgmax<T> create(Scope scope, Operand<T> input, Operand<T> grad, Operand<? extends TNumber> argmax, List<Long> ksize, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(argmax.asOutput());
        long[] ksizeArray = new long[ksize.size()];
        for (int i = 0; i < ksizeArray.length; ++i) {
            ksizeArray[i] = ksize.get(i);
        }
        opBuilder.setAttr("ksize", ksizeArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.includeBatchInIndex == null) continue;
                opBuilder.setAttr("include_batch_in_index", opts.includeBatchInIndex);
            }
        }
        return new MaxPoolGradGradWithArgmax<T>(opBuilder.build());
    }

    public static Options includeBatchInIndex(Boolean includeBatchInIndex) {
        return new Options().includeBatchInIndex(includeBatchInIndex);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=MaxPoolGradGradWithArgmax.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<MaxPoolGradGradWithArgmax<T>> {
        public final Operand<T> input;
        public final Operand<T> grad;
        public final Operand<? extends TNumber> argmax;
        public final long[] ksize;
        public final long[] strides;
        public final String padding;
        public final boolean includeBatchInIndex;
        public final DataType Targmax;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new MaxPoolGradGradWithArgmax(op), op, Arrays.asList("ksize", "strides", "padding", "include_batch_in_index", "Targmax", "T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.grad = op.input(inputIndex++);
            this.argmax = op.input(inputIndex++);
            this.ksize = op.attributes().getAttrIntList("ksize");
            this.strides = op.attributes().getAttrIntList("strides");
            this.padding = op.attributes().getAttrString("padding");
            this.includeBatchInIndex = op.attributes().getAttrBool("include_batch_in_index");
            this.Targmax = op.attributes().getAttrType("Targmax");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean includeBatchInIndex;

        private Options() {
        }

        public Options includeBatchInIndex(Boolean includeBatchInIndex) {
            this.includeBatchInIndex = includeBatchInIndex;
            return this;
        }
    }
}

