/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUAnnotateTensorsWithDynamicShape", inputsClass=Inputs.class)
public final class TPUAnnotateTensorsWithDynamicShape
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "TPUAnnotateTensorsWithDynamicShape";
    private List<Output<?>> tpuTensors;

    public TPUAnnotateTensorsWithDynamicShape(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int tpuTensorsLength = operation.outputListLength("tpu_tensors");
        this.tpuTensors = Arrays.asList(operation.outputList(outputIdx, tpuTensorsLength));
        outputIdx += tpuTensorsLength;
    }

    public static TPUAnnotateTensorsWithDynamicShape create(Scope scope, Iterable<Operand<?>> tensors) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(tensors));
        return new TPUAnnotateTensorsWithDynamicShape(opBuilder.build());
    }

    public List<Output<?>> tpuTensors() {
        return this.tpuTensors;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.tpuTensors.iterator();
    }

    @OpInputsMetadata(outputsClass=TPUAnnotateTensorsWithDynamicShape.class)
    public static class Inputs
    extends RawOpInputs<TPUAnnotateTensorsWithDynamicShape> {
        public final Iterable<Operand<?>> tensors;
        public final DataType[] T;

        public Inputs(GraphOperation op) {
            super(new TPUAnnotateTensorsWithDynamicShape(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            int tensorsLength = op.inputListLength("tensors");
            this.tensors = Arrays.asList((Operand[])op.inputList(inputIndex, tensorsLength));
            inputIndex += tensorsLength;
            this.T = op.attributes().getAttrTypeList("T");
        }
    }
}

