/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="SparseSegmentSqrtNWithNumSegments", inputsClass=Inputs.class)
public final class SparseSegmentSqrtNWithNumSegments<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "SparseSegmentSqrtNWithNumSegments";
    private Output<T> output;

    public SparseSegmentSqrtNWithNumSegments(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> SparseSegmentSqrtNWithNumSegments<T> create(Scope scope, Operand<T> data, Operand<? extends TNumber> indices, Operand<? extends TNumber> segmentIds, Operand<? extends TNumber> numSegments, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(data.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(segmentIds.asOutput());
        opBuilder.addInput(numSegments.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.sparseGradient == null) continue;
                opBuilder.setAttr("sparse_gradient", opts.sparseGradient);
            }
        }
        return new SparseSegmentSqrtNWithNumSegments<T>(opBuilder.build());
    }

    public static Options sparseGradient(Boolean sparseGradient) {
        return new Options().sparseGradient(sparseGradient);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SparseSegmentSqrtNWithNumSegments.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<SparseSegmentSqrtNWithNumSegments<T>> {
        public final Operand<T> data;
        public final Operand<? extends TNumber> indices;
        public final Operand<? extends TNumber> segmentIds;
        public final Operand<? extends TNumber> numSegments;
        public final DataType T;
        public final DataType Tidx;
        public final DataType Tnumsegments;
        public final DataType Tsegmentids;
        public final boolean sparseGradient;

        public Inputs(GraphOperation op) {
            super(new SparseSegmentSqrtNWithNumSegments(op), op, Arrays.asList("T", "Tidx", "Tnumsegments", "Tsegmentids", "sparse_gradient"));
            int inputIndex = 0;
            this.data = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.segmentIds = op.input(inputIndex++);
            this.numSegments = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tidx = op.attributes().getAttrType("Tidx");
            this.Tnumsegments = op.attributes().getAttrType("Tnumsegments");
            this.Tsegmentids = op.attributes().getAttrType("Tsegmentids");
            this.sparseGradient = op.attributes().getAttrBool("sparse_gradient");
        }
    }

    public static class Options {
        private Boolean sparseGradient;

        private Options() {
        }

        public Options sparseGradient(Boolean sparseGradient) {
            this.sparseGradient = sparseGradient;
            return this;
        }
    }
}

