/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalCSVDataset", inputsClass=Inputs.class)
public final class CSVDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalCSVDataset";
    private Output<? extends TType> handle;

    public CSVDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static CSVDataset create(Scope scope, Operand<TString> filenames, Operand<TString> compressionType, Operand<TInt64> bufferSize, Operand<TBool> header, Operand<TString> fieldDelim, Operand<TBool> useQuoteDelim, Operand<TString> naValue, Operand<TInt64> selectCols, Iterable<Operand<?>> recordDefaults, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CSVDataset");
        opBuilder.addInput(filenames.asOutput());
        opBuilder.addInput(compressionType.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder.addInput(header.asOutput());
        opBuilder.addInput(fieldDelim.asOutput());
        opBuilder.addInput(useQuoteDelim.asOutput());
        opBuilder.addInput(naValue.asOutput());
        opBuilder.addInput(selectCols.asOutput());
        opBuilder.addInputList(Operands.asOutputs(recordDefaults));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new CSVDataset(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=CSVDataset.class)
    public static class Inputs
    extends RawOpInputs<CSVDataset> {
        public final Operand<TString> filenames;
        public final Operand<TString> compressionType;
        public final Operand<TInt64> bufferSize;
        public final Operand<TBool> header;
        public final Operand<TString> fieldDelim;
        public final Operand<TBool> useQuoteDelim;
        public final Operand<TString> naValue;
        public final Operand<TInt64> selectCols;
        public final Iterable<Operand<?>> recordDefaults;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new CSVDataset(op), op, Arrays.asList("output_types", "output_shapes"));
            int inputIndex = 0;
            this.filenames = op.input(inputIndex++);
            this.compressionType = op.input(inputIndex++);
            this.bufferSize = op.input(inputIndex++);
            this.header = op.input(inputIndex++);
            this.fieldDelim = op.input(inputIndex++);
            this.useQuoteDelim = op.input(inputIndex++);
            this.naValue = op.input(inputIndex++);
            this.selectCols = op.input(inputIndex++);
            int recordDefaultsLength = op.inputListLength("record_defaults");
            this.recordDefaults = Arrays.asList((Operand[])op.inputList(inputIndex, recordDefaultsLength));
            inputIndex += recordDefaultsLength;
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

