/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="PrefetchDataset", inputsClass=Inputs.class)
public final class PrefetchDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "PrefetchDataset";
    private Output<? extends TType> handle;

    public PrefetchDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static PrefetchDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> bufferSize, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.slackPeriod != null) {
                    opBuilder.setAttr("slack_period", opts.slackPeriod);
                }
                if (opts.legacyAutotune != null) {
                    opBuilder.setAttr("legacy_autotune", opts.legacyAutotune);
                }
                if (opts.bufferSizeMin != null) {
                    opBuilder.setAttr("buffer_size_min", opts.bufferSizeMin);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new PrefetchDataset(opBuilder.build());
    }

    public static Options slackPeriod(Long slackPeriod) {
        return new Options().slackPeriod(slackPeriod);
    }

    public static Options legacyAutotune(Boolean legacyAutotune) {
        return new Options().legacyAutotune(legacyAutotune);
    }

    public static Options bufferSizeMin(Long bufferSizeMin) {
        return new Options().bufferSizeMin(bufferSizeMin);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=PrefetchDataset.class)
    public static class Inputs
    extends RawOpInputs<PrefetchDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> bufferSize;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final long slackPeriod;
        public final boolean legacyAutotune;
        public final long bufferSizeMin;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new PrefetchDataset(op), op, Arrays.asList("output_types", "output_shapes", "slack_period", "legacy_autotune", "buffer_size_min", "metadata"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.bufferSize = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.slackPeriod = op.attributes().getAttrInt("slack_period");
            this.legacyAutotune = op.attributes().getAttrBool("legacy_autotune");
            this.bufferSizeMin = op.attributes().getAttrInt("buffer_size_min");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private Long slackPeriod;
        private Boolean legacyAutotune;
        private Long bufferSizeMin;
        private String metadata;

        private Options() {
        }

        public Options slackPeriod(Long slackPeriod) {
            this.slackPeriod = slackPeriod;
            return this;
        }

        public Options legacyAutotune(Boolean legacyAutotune) {
            this.legacyAutotune = legacyAutotune;
            return this;
        }

        public Options bufferSizeMin(Long bufferSizeMin) {
            this.bufferSizeMin = bufferSizeMin;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

