/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="AddSparseToTensorsMap", inputsClass=Inputs.class)
public final class AddSparseToTensorsMap
extends RawOp
implements Operand<TInt64> {
    public static final String OP_NAME = "AddSparseToTensorsMap";
    private Output<TInt64> sparseHandle;

    public AddSparseToTensorsMap(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sparseHandle = operation.output(outputIdx++);
    }

    public static AddSparseToTensorsMap create(Scope scope, Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(sparseIndices.asOutput());
        opBuilder.addInput(sparseValues.asOutput());
        opBuilder.addInput(sparseShape.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new AddSparseToTensorsMap(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<TInt64> sparseHandle() {
        return this.sparseHandle;
    }

    @Override
    public Output<TInt64> asOutput() {
        return this.sparseHandle;
    }

    @OpInputsMetadata(outputsClass=AddSparseToTensorsMap.class)
    public static class Inputs
    extends RawOpInputs<AddSparseToTensorsMap> {
        public final Operand<TInt64> sparseIndices;
        public final Operand<? extends TType> sparseValues;
        public final Operand<TInt64> sparseShape;
        public final DataType T;
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new AddSparseToTensorsMap(op), op, Arrays.asList("T", "container", "shared_name"));
            int inputIndex = 0;
            this.sparseIndices = op.input(inputIndex++);
            this.sparseValues = op.input(inputIndex++);
            this.sparseShape = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

