/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.DoubleNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.SparseSlice;
import org.tensorflow.ndarray.index.Index;

public class DoubleSparseSlice
extends SparseSlice<Double, DoubleNdArray>
implements DoubleNdArray {
    public DoubleSparseSlice(AbstractSparseNdArray<Double, DoubleNdArray> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source, sourcePosition, dimensions);
    }

    @Override
    public DoubleNdArray toDense() {
        DoubleDataBuffer dataBuffer = DataBuffers.ofDoubles(this.shape().size());
        this.copyTo(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    @Override
    public double getDouble(long ... coordinates) {
        return (Double)this.getObject(coordinates);
    }

    @Override
    public DoubleNdArray setDouble(double value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleNdArray setObject(Double value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleNdArray set(NdArray<Double> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleNdArray copyTo(DataBuffer<Double> dst) {
        Object[] defaults = new Double[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write((Double[])defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            double value = ((DoubleNdArray)this.getValues()).getDouble(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public DoubleNdArray copyTo(DoubleDataBuffer dst) {
        return this.copyTo((DataBuffer)dst);
    }

    @Override
    public DoubleNdArray copyFrom(DataBuffer<Double> src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleNdArray copyFrom(DoubleDataBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleNdArray slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public DoubleNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new DoubleSparseSlice(this.source, position + this.sourcePosition, sliceDimensions);
    }

    @Override
    public DoubleNdArray get(long ... coordinates) {
        return (DoubleNdArray)super.get(coordinates);
    }

    @Override
    public DoubleNdArray copyTo(NdArray<Double> dst) {
        return (DoubleNdArray)super.copyTo(dst);
    }

    @Override
    public DoubleNdArray createDefaultArray() {
        return (DoubleNdArray)this.source.getDefaultArray();
    }
}

