/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="StackV2", inputsClass=Inputs.class)
public final class StackCreate
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "StackV2";
    private Output<? extends TType> handle;

    public StackCreate(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static <T extends TType> StackCreate create(Scope scope, Operand<TInt32> maxSize, Class<T> elemType, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "StackCreate");
        opBuilder.addInput(maxSize.asOutput());
        opBuilder.setAttr("elem_type", Operands.toDataType(elemType));
        if (options != null) {
            for (Options opts : options) {
                if (opts.stackName == null) continue;
                opBuilder.setAttr("stack_name", opts.stackName);
            }
        }
        return new StackCreate(opBuilder.build());
    }

    public static Options stackName(String stackName) {
        return new Options().stackName(stackName);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=StackCreate.class)
    public static class Inputs
    extends RawOpInputs<StackCreate> {
        public final Operand<TInt32> maxSize;
        public final DataType elemType;
        public final String stackName;

        public Inputs(GraphOperation op) {
            super(new StackCreate(op), op, Arrays.asList("elem_type", "stack_name"));
            int inputIndex = 0;
            this.maxSize = op.input(inputIndex++);
            this.elemType = op.attributes().getAttrType("elem_type");
            this.stackName = op.attributes().getAttrString("stack_name");
        }
    }

    public static class Options {
        private String stackName;

        private Options() {
        }

        public Options stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }
    }
}

