/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizedConv2DWithBiasSignedSumAndReluAndRequantize", inputsClass=Inputs.class)
public final class QuantizedConv2DWithBiasSignedSumAndReluAndRequantize<X extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizedConv2DWithBiasSignedSumAndReluAndRequantize";
    private Output<X> output;
    private Output<TFloat32> minOutput;
    private Output<TFloat32> maxOutput;

    public QuantizedConv2DWithBiasSignedSumAndReluAndRequantize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOutput = operation.output(outputIdx++);
        this.maxOutput = operation.output(outputIdx++);
    }

    public static <X extends TNumber> QuantizedConv2DWithBiasSignedSumAndReluAndRequantize<X> create(Scope scope, Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<? extends TNumber> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Operand<? extends TNumber> summand, Operand<TFloat32> minSummand, Operand<TFloat32> maxSummand, Class<X> outType, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        opBuilder.addInput(minFilter.asOutput());
        opBuilder.addInput(maxFilter.asOutput());
        opBuilder.addInput(minFreezedOutput.asOutput());
        opBuilder.addInput(maxFreezedOutput.asOutput());
        opBuilder.addInput(summand.asOutput());
        opBuilder.addInput(minSummand.asOutput());
        opBuilder.addInput(maxSummand.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.dilations != null) {
                    long[] dilationsArray = new long[opts.dilations.size()];
                    for (i = 0; i < dilationsArray.length; ++i) {
                        dilationsArray[i] = opts.dilations.get(i);
                    }
                    opBuilder.setAttr("dilations", dilationsArray);
                }
                if (opts.paddingList == null) continue;
                long[] paddingListArray = new long[opts.paddingList.size()];
                for (i = 0; i < paddingListArray.length; ++i) {
                    paddingListArray[i] = opts.paddingList.get(i);
                }
                opBuilder.setAttr("padding_list", paddingListArray);
            }
        }
        return new QuantizedConv2DWithBiasSignedSumAndReluAndRequantize<X>(opBuilder.build());
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public static Options dilations(Long ... dilations) {
        return new Options().dilations(dilations);
    }

    public static Options paddingList(List<Long> paddingList) {
        return new Options().paddingList(paddingList);
    }

    public static Options paddingList(Long ... paddingList) {
        return new Options().paddingList(paddingList);
    }

    public Output<X> output() {
        return this.output;
    }

    public Output<TFloat32> minOutput() {
        return this.minOutput;
    }

    public Output<TFloat32> maxOutput() {
        return this.maxOutput;
    }

    @OpInputsMetadata(outputsClass=QuantizedConv2DWithBiasSignedSumAndReluAndRequantize.class)
    public static class Inputs
    extends RawOpInputs<QuantizedConv2DWithBiasSignedSumAndReluAndRequantize<?>> {
        public final Operand<? extends TNumber> input;
        public final Operand<? extends TNumber> filter;
        public final Operand<? extends TNumber> bias;
        public final Operand<TFloat32> minInput;
        public final Operand<TFloat32> maxInput;
        public final Operand<TFloat32> minFilter;
        public final Operand<TFloat32> maxFilter;
        public final Operand<TFloat32> minFreezedOutput;
        public final Operand<TFloat32> maxFreezedOutput;
        public final Operand<? extends TNumber> summand;
        public final Operand<TFloat32> minSummand;
        public final Operand<TFloat32> maxSummand;
        public final DataType Tinput;
        public final DataType Tfilter;
        public final DataType Tbias;
        public final DataType Tsummand;
        public final DataType outType;
        public final long[] strides;
        public final String padding;
        public final long[] dilations;
        public final long[] paddingList;

        public Inputs(GraphOperation op) {
            super(new QuantizedConv2DWithBiasSignedSumAndReluAndRequantize(op), op, Arrays.asList("Tinput", "Tfilter", "Tbias", "Tsummand", "out_type", "strides", "padding", "dilations", "padding_list"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.filter = op.input(inputIndex++);
            this.bias = op.input(inputIndex++);
            this.minInput = op.input(inputIndex++);
            this.maxInput = op.input(inputIndex++);
            this.minFilter = op.input(inputIndex++);
            this.maxFilter = op.input(inputIndex++);
            this.minFreezedOutput = op.input(inputIndex++);
            this.maxFreezedOutput = op.input(inputIndex++);
            this.summand = op.input(inputIndex++);
            this.minSummand = op.input(inputIndex++);
            this.maxSummand = op.input(inputIndex++);
            this.Tinput = op.attributes().getAttrType("Tinput");
            this.Tfilter = op.attributes().getAttrType("Tfilter");
            this.Tbias = op.attributes().getAttrType("Tbias");
            this.Tsummand = op.attributes().getAttrType("Tsummand");
            this.outType = op.attributes().getAttrType("out_type");
            this.strides = op.attributes().getAttrIntList("strides");
            this.padding = op.attributes().getAttrString("padding");
            this.dilations = op.attributes().getAttrIntList("dilations");
            this.paddingList = op.attributes().getAttrIntList("padding_list");
        }
    }

    public static class Options {
        private List<Long> dilations;
        private List<Long> paddingList;

        private Options() {
        }

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        public Options dilations(Long ... dilations) {
            this.dilations = Arrays.asList(dilations);
            return this;
        }

        public Options paddingList(List<Long> paddingList) {
            this.paddingList = paddingList;
            return this;
        }

        public Options paddingList(Long ... paddingList) {
            this.paddingList = Arrays.asList(paddingList);
            return this;
        }
    }
}

