/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RestoreSlice", inputsClass=Inputs.class)
public final class RestoreSlice<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RestoreSlice";
    private Output<T> tensor;

    public RestoreSlice(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
    }

    public static <T extends TType> RestoreSlice<T> create(Scope scope, Operand<TString> filePattern, Operand<TString> tensorName, Operand<TString> shapeAndSlice, Class<T> dt, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(filePattern.asOutput());
        opBuilder.addInput(tensorName.asOutput());
        opBuilder.addInput(shapeAndSlice.asOutput());
        opBuilder.setAttr("dt", Operands.toDataType(dt));
        if (options != null) {
            for (Options opts : options) {
                if (opts.preferredShard == null) continue;
                opBuilder.setAttr("preferred_shard", opts.preferredShard);
            }
        }
        return new RestoreSlice<T>(opBuilder.build());
    }

    public static Options preferredShard(Long preferredShard) {
        return new Options().preferredShard(preferredShard);
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.tensor;
    }

    @OpInputsMetadata(outputsClass=RestoreSlice.class)
    public static class Inputs
    extends RawOpInputs<RestoreSlice<?>> {
        public final Operand<TString> filePattern;
        public final Operand<TString> tensorName;
        public final Operand<TString> shapeAndSlice;
        public final DataType dt;
        public final long preferredShard;

        public Inputs(GraphOperation op) {
            super(new RestoreSlice(op), op, Arrays.asList("dt", "preferred_shard"));
            int inputIndex = 0;
            this.filePattern = op.input(inputIndex++);
            this.tensorName = op.input(inputIndex++);
            this.shapeAndSlice = op.input(inputIndex++);
            this.dt = op.attributes().getAttrType("dt");
            this.preferredShard = op.attributes().getAttrInt("preferred_shard");
        }
    }

    public static class Options {
        private Long preferredShard;

        private Options() {
        }

        public Options preferredShard(Long preferredShard) {
            this.preferredShard = preferredShard;
            return this;
        }
    }
}

