/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RiscDot", inputsClass=Inputs.class)
public final class RiscDot<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RiscDot";
    private Output<T> product;

    public RiscDot(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.product = operation.output(outputIdx++);
    }

    public static <T extends TNumber> RiscDot<T> create(Scope scope, Operand<T> a, Operand<T> b, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB == null) continue;
                opBuilder.setAttr("transpose_b", opts.transposeB);
            }
        }
        return new RiscDot<T>(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public Output<T> product() {
        return this.product;
    }

    @Override
    public Output<T> asOutput() {
        return this.product;
    }

    @OpInputsMetadata(outputsClass=RiscDot.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<RiscDot<T>> {
        public final Operand<T> a;
        public final Operand<T> b;
        public final boolean transposeA;
        public final boolean transposeB;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new RiscDot(op), op, Arrays.asList("transpose_a", "transpose_b", "T"));
            int inputIndex = 0;
            this.a = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.transposeA = op.attributes().getAttrBool("transpose_a");
            this.transposeB = op.attributes().getAttrBool("transpose_b");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;

        private Options() {
        }

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }
    }
}

