/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.summary.AudioSummary;
import org.tensorflow.op.summary.HistogramSummary;
import org.tensorflow.op.summary.ImageSummary;
import org.tensorflow.op.summary.MergeSummary;
import org.tensorflow.op.summary.ScalarSummary;
import org.tensorflow.op.summary.TensorSummary;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class SummaryOps {
    private final Scope scope;
    private final Ops ops;

    SummaryOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public AudioSummary audioSummary(Operand<TString> tag, Operand<TFloat32> tensor, Operand<TFloat32> sampleRate, AudioSummary.Options ... options) {
        return AudioSummary.create(this.scope, tag, tensor, sampleRate, options);
    }

    public HistogramSummary histogramSummary(Operand<TString> tag, Operand<? extends TNumber> values) {
        return HistogramSummary.create(this.scope, tag, values);
    }

    public ImageSummary imageSummary(Operand<TString> tag, Operand<? extends TNumber> tensor, ImageSummary.Options ... options) {
        return ImageSummary.create(this.scope, tag, tensor, options);
    }

    public MergeSummary mergeSummary(Iterable<Operand<TString>> inputs) {
        return MergeSummary.create(this.scope, inputs);
    }

    public ScalarSummary scalarSummary(Operand<TString> tags, Operand<? extends TNumber> values) {
        return ScalarSummary.create(this.scope, tags, values);
    }

    public TensorSummary tensorSummary(Operand<TString> tag, Operand<? extends TType> tensor, Operand<TString> serializedSummaryMetadata) {
        return TensorSummary.create(this.scope, tag, tensor, serializedSummaryMetadata);
    }

    public final Ops ops() {
        return this.ops;
    }
}

