/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.IntNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.SparseSlice;
import org.tensorflow.ndarray.index.Index;

public class IntSparseSlice
extends SparseSlice<Integer, IntNdArray>
implements IntNdArray {
    public IntSparseSlice(AbstractSparseNdArray<Integer, IntNdArray> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source, sourcePosition, dimensions);
    }

    @Override
    public IntNdArray toDense() {
        IntDataBuffer dataBuffer = DataBuffers.ofInts(this.shape().size());
        this.read(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    @Override
    public int getInt(long ... coordinates) {
        return (Integer)this.getObject(coordinates);
    }

    @Override
    public IntNdArray setInt(int value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntNdArray setObject(Integer value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntNdArray set(NdArray<Integer> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntNdArray read(DataBuffer<Integer> dst) {
        Object[] defaults = new Integer[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write((Integer[])defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            int value = ((IntNdArray)this.getValues()).getInt(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public IntNdArray read(IntDataBuffer dst) {
        return this.read((DataBuffer)dst);
    }

    @Override
    public IntNdArray write(DataBuffer<Integer> src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntNdArray write(IntDataBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntNdArray slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public IntNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new IntSparseSlice(this.source, position + this.sourcePosition, sliceDimensions);
    }

    @Override
    public IntNdArray get(long ... coordinates) {
        return (IntNdArray)super.get(coordinates);
    }

    @Override
    public IntNdArray copyTo(NdArray<Integer> dst) {
        return (IntNdArray)super.copyTo(dst);
    }

    @Override
    public IntNdArray createDefaultArray() {
        return (IntNdArray)this.source.getDefaultArray();
    }
}

