/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseMatrixTranspose", inputsClass=Inputs.class)
public final class SparseMatrixTranspose
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SparseMatrixTranspose";
    private Output<? extends TType> output;

    public SparseMatrixTranspose(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseMatrixTranspose create(Scope scope, Operand<? extends TType> input, Class<T> type, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("type", Operands.toDataType(type));
        if (options != null) {
            for (Options opts : options) {
                if (opts.conjugate == null) continue;
                opBuilder.setAttr("conjugate", opts.conjugate);
            }
        }
        return new SparseMatrixTranspose(opBuilder.build());
    }

    public static Options conjugate(Boolean conjugate) {
        return new Options().conjugate(conjugate);
    }

    public Output<? extends TType> output() {
        return this.output;
    }

    @Override
    public Output<TType> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SparseMatrixTranspose.class)
    public static class Inputs
    extends RawOpInputs<SparseMatrixTranspose> {
        public final Operand<? extends TType> input;
        public final boolean conjugate;
        public final DataType type;

        public Inputs(GraphOperation op) {
            super(new SparseMatrixTranspose(op), op, Arrays.asList("conjugate", "type"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.conjugate = op.attributes().getAttrBool("conjugate");
            this.type = op.attributes().getAttrType("type");
        }
    }

    public static class Options {
        private Boolean conjugate;

        private Options() {
        }

        public Options conjugate(Boolean conjugate) {
            this.conjugate = conjugate;
            return this;
        }
    }
}

