/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ApproxTopK", inputsClass=Inputs.class)
public final class ApproxTopK<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "ApproxTopK";
    private Output<T> values;
    private Output<TInt32> indices;

    public ApproxTopK(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.values = operation.output(outputIdx++);
        this.indices = operation.output(outputIdx++);
    }

    public static <T extends TNumber> ApproxTopK<T> create(Scope scope, Operand<T> input, Long k, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("k", k);
        if (options != null) {
            for (Options opts : options) {
                if (opts.reductionDimension != null) {
                    opBuilder.setAttr("reduction_dimension", opts.reductionDimension);
                }
                if (opts.recallTarget != null) {
                    opBuilder.setAttr("recall_target", opts.recallTarget.floatValue());
                }
                if (opts.isMaxK != null) {
                    opBuilder.setAttr("is_max_k", opts.isMaxK);
                }
                if (opts.reductionInputSizeOverride != null) {
                    opBuilder.setAttr("reduction_input_size_override", opts.reductionInputSizeOverride);
                }
                if (opts.aggregateToTopk == null) continue;
                opBuilder.setAttr("aggregate_to_topk", opts.aggregateToTopk);
            }
        }
        return new ApproxTopK<T>(opBuilder.build());
    }

    public static Options reductionDimension(Long reductionDimension) {
        return new Options().reductionDimension(reductionDimension);
    }

    public static Options recallTarget(Float recallTarget) {
        return new Options().recallTarget(recallTarget);
    }

    public static Options isMaxK(Boolean isMaxK) {
        return new Options().isMaxK(isMaxK);
    }

    public static Options reductionInputSizeOverride(Long reductionInputSizeOverride) {
        return new Options().reductionInputSizeOverride(reductionInputSizeOverride);
    }

    public static Options aggregateToTopk(Boolean aggregateToTopk) {
        return new Options().aggregateToTopk(aggregateToTopk);
    }

    public Output<T> values() {
        return this.values;
    }

    public Output<TInt32> indices() {
        return this.indices;
    }

    @OpInputsMetadata(outputsClass=ApproxTopK.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<ApproxTopK<T>> {
        public final Operand<T> input;
        public final long k;
        public final long reductionDimension;
        public final float recallTarget;
        public final boolean isMaxK;
        public final long reductionInputSizeOverride;
        public final boolean aggregateToTopk;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new ApproxTopK(op), op, Arrays.asList("k", "reduction_dimension", "recall_target", "is_max_k", "reduction_input_size_override", "aggregate_to_topk", "T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.k = op.attributes().getAttrInt("k");
            this.reductionDimension = op.attributes().getAttrInt("reduction_dimension");
            this.recallTarget = op.attributes().getAttrFloat("recall_target");
            this.isMaxK = op.attributes().getAttrBool("is_max_k");
            this.reductionInputSizeOverride = op.attributes().getAttrInt("reduction_input_size_override");
            this.aggregateToTopk = op.attributes().getAttrBool("aggregate_to_topk");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Long reductionDimension;
        private Float recallTarget;
        private Boolean isMaxK;
        private Long reductionInputSizeOverride;
        private Boolean aggregateToTopk;

        private Options() {
        }

        public Options reductionDimension(Long reductionDimension) {
            this.reductionDimension = reductionDimension;
            return this;
        }

        public Options recallTarget(Float recallTarget) {
            this.recallTarget = recallTarget;
            return this;
        }

        public Options isMaxK(Boolean isMaxK) {
            this.isMaxK = isMaxK;
            return this;
        }

        public Options reductionInputSizeOverride(Long reductionInputSizeOverride) {
            this.reductionInputSizeOverride = reductionInputSizeOverride;
            return this;
        }

        public Options aggregateToTopk(Boolean aggregateToTopk) {
            this.aggregateToTopk = aggregateToTopk;
            return this;
        }
    }
}

